#!/usr/bin/perl

BEGIN {
	do "../genquire.conf";
}

use strict;
use DBI;
use GQ::Server::DB::DbObj;
use Term::ReadKey;

use vars qw ($dbobj $context $MySQL_IP);

my ($user, $pass, $driver, $db);
print "Enter your username: ";
chomp($user=<STDIN>);
print "Enter your password: ";
ReadMode 'noecho';
$pass = ReadLine 0;
chomp $pass;
ReadMode 'normal';
print "\n";
$| = 1;
print "Enter your database IP address (and port if not default): ";
chomp($MySQL_IP=<STDIN>);
print "Enter the database (name) to be indexed: ";
chomp($db=<STDIN>);
my $dbobj=GQ::Server::DB::DbObj->new($user,$pass,$db,$MySQL_IP);
my $dbh=$dbobj->dbh;

$dbh->do("DELETE FROM WordBase");
$dbh->do("DELETE FROM fid");

$dbh->commit;
my $sth=$dbh->prepare("SELECT feature_id,Feature.contig_id, Tags.tag,value FROM TagValue,Tags, Feature where TagValue.tag=Tags.id and Feature.id = feature_id");
my $sth_check_fid=$dbh->prepare("Select id from fid where feature_id=? and contig_id=?");
my $sth_create_fid=$dbh->prepare("INSERT INTO fid (feature_id, contig_id) VALUES (?,?)");
my $sth_getGOterm=$dbh->prepare("SELECT term FROM GO_local WHERE id=?");
my $sth_insertWordBase=$dbh->prepare("INSERT IGNORE INTO WordBase (word,fid) VALUES (?,?)");
my $sth_getWordID=$dbh->prepare('SELECT id FROM Word WHERE word LIKE ?');
my $sth7=$dbh->prepare("INSERT INTO Word (word) VALUES (?)");

print "\nNow indexing:";

$sth->execute;

while (my ($feat,$cont,$tag,$val)=$sth->fetchrow_array) {
    $sth_check_fid->execute($feat, $cont);	# create a fid
	my $fid = $sth_check_fid->fetchrow_array;
	unless ($fid){
		$sth_create_fid->execute($feat, $cont);	# create a fid
		$fid=$dbh->{mysql_insertid};			# get its index
	}
	my $text='';
    foreach ($tag,$val) {
		$text .= "$_ ";
    }
    if ($tag eq 'GO_annotation') {
		$sth_getGOterm->execute($val);
		my ($term)=$sth_getGOterm->fetchrow_array;
		$text .= "$term";
    }
    $_=$text;
    my @lil_words=split /[\W\s_\(\)\{\}\.,?\-\/\\]/,$text;  #split on punctuation
    foreach (@lil_words) {
		next unless $_;
		my $wid=_check_word($dbobj,$_);  # for each word get its word id
		$sth_insertWordBase->execute($wid,$fid);  # then insert the word_id and the fid_id into the wordbase
    }
    $dbh->commit;
    print ".";
}


print "\n\nINDEXING COMPLETE.\n";
exit;   #end of program

sub _check_word {
    my ($dbobj,$word)=@_;
    $sth_getWordID->execute($word);
    while (my ($wid)=$sth_getWordID->fetchrow_array) {
	return $wid;
    }
    #we're here, so there is no such word.  Insert it.
    $sth7->execute($word) or die "Couldn't insert $word into Word table: $DBI::errstr";
    my $wid=$dbh->{mysql_insertid};
    return $wid;
}
