# GQ::Server::Container module for Genquire

# by David Block <dblock@gene.pbir.nrc.ca>

# Copyright David Block and NRC-PBI

# POD Documentation - main docs before the code

=head1 NAME

Container - GQ::Server::Container object for Genquire

=head1 SYNOPSIS

=head1 DESCRIPTION

=head1 FEEDBACK

Like it or lump it, report to dblock@gene.pbi.nrc.ca.  Feel free to add
to the docs available at
http://bioinfo.pbi.nrc.ca/dblock/wiki

=head2 Reporting Bugs

Email the author with any bug reports.

=head1 AUTHOR - David Block

email dblock@gene.pbi.nrc.ca

=cut

package GQ::Server::Container;
$VERSION = 1.00;
use strict;

use vars qw( $AUTOLOAD @ISA);  #Keep 'use strict' happy

use Carp;
use DBI;

use GQ::Server::GenericFeature;
use GQ::Root;

@ISA = qw(GQ::Server::GenericFeature);
{
    #Encapsulated class data
    #replace with your column names, and sensible defaults

                                #       DEFAULT      ACCESSIBILITY
    GQ::Root->create(  features      =>  [undef,        'read/write'],
		    );
}

sub _db_keys {
    my ($self)=@_;
    my @list;
    foreach ($self->SUPER::_db_keys) {
	push @list,$_ unless /^id$|features/;
    }

    push @list,'id';
    return @list;
}


### write in any custom subroutines here

sub _new_feature {
    my ($self,$arg)=@_;
    my $new;
    if ($arg) {
	if ($arg->isa('GQ::Server::GenericFeature')) {
	    $new=$arg;
	    $new->name($self->name) if $new->name ne $self->name;
	} else {
	    $new=GQ::Server::Feature->new(%$arg,
					  lockid  =>$self->lockid,
					  name    =>$self->name);
	}
	$self->adaptor->add_feature($self,$new);
	$self->{features}{$new->id}=$new;
    }
}

sub features_hash {
    my ($self,$arg)=@_;
    if ($arg) {
	my @arg=(ref($arg) eq 'LIST')?@$arg:($arg);
	foreach my $this (@arg) {
	    $self->_new_feature($this);
	}
    }
    if ($self->{features}) {
	return $self->{features};
    } else {
	return {};
    }
}

sub features {
    my ($self,$arg)=@_;
    return values %{$self->features_hash($arg)};
}

sub feature { return $_[0]->{features}{$_[1]} }

sub flesh_out_details {
    require GQ::Server::Feature::inMemory;
    my $self=shift;
    my $local;
    print "before $self\n";
    my $noasbdhasbhdbahsd = <STDIN>;
    return unless ($self->features);
    print "after\n";
    foreach ($self->features) {
	return unless $_ && $_->can('absstart');
    }
    my $first=1;
    foreach my $feature (sort {$a->absstart <=> $b->absstart} $self->features) {
	if ($first) {
	    $local=GQ::Server::Feature::inMemory->new(%$feature);
	    $first=0;
	} else {
	    if ($feature->absstart < $local->absstart) {
		$local->contig_start($feature->contig_start);
		$local->contig_id($feature->contig_id);
	    }
	    if ($feature->absstop > $local->absstop) {
		if ($feature->contig_id eq $local->contig_id) {
		    $local->contig_stop($feature->contig_stop);
		} else {
		    my $difference=$self->adaptor->diff($self,$feature);
		    $local->contig_stop($feature->contig_stop + $difference);
		}
	    }
	}
    }
    $self->contig_id   ($local->contig_id)    if $self->contig_id    != $local->contig_id;
    $self->contig_start($local->contig_start) if $self->contig_start != $local->contig_start;
    $self->contig_stop ($local->contig_stop)  if $self->contig_stop  != $local->contig_stop;
    $self->strand      ($local->strand)       if $self->strand       ne $local->strand;
    $self->length ($self->end - $self->start + 1) if $self->length   != ($self->end - $self->start + 1);
}

1;





