{***************************************************************************
 *
 * Author:     Alberto Pascual Montano (pascual@fis.ucm.es)
 *             http://www.dacya.ucm.es/apascual

 * Complutense University of Madrid (UCM). Madrid, Spain
 * The KEY Institute for Brain-Mind Research, Zurich, Switzerland
 * National Center for Biotechnology (CNB). Madrid, Spain
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 *  All comments concerning this program package may be sent to the
 *  e-mail address 'pascual@fis.ucm.es'
 ***************************************************************************}

unit consensus;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, uMatToolsDyn, microarray, StdCtrls;

type
  TconsensusForm = class(TForm)
    Image1: TImage;
    nextBut: TButton;
    PreviousBut: TButton;
    FactorLabel: TLabel;
    Vlabel: TLabel;
    CophLabel: TLabel;
    Image2: TImage;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    minLabel: TLabel;
    ClassLabel: TLabel;
    saveconsensus: TButton;
    savecoph: TButton;
    SaveDialog1: TSaveDialog;
    procedure FormShow(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure nextButClick(Sender: TObject);
    procedure PreviousButClick(Sender: TObject);
    procedure Image1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure saveconsensusClick(Sender: TObject);
    procedure savecophClick(Sender: TObject);
  private
    { Private declarations }
    maskx, masky: intvector;
    procedure PaintImage(Sender: TObject);
    procedure PaintCoph(Sender: TObject);
  public
    { Public declarations }
    varlabels: ^stringvector;
    numberofrowheaders: integer;
  end;

  TMatrixRecord = record
     K:integer;
     coph: double;
     index: intvector;
     indexcluster: intvector;
     mat: matrix;
  end;
  TInternalMatrixRecordVector=array[1..1] of TMatrixRecord;
  matrixvector=^TInternalMatrixRecordVector;
  TInternalVectorRecordVector=array[1..1] of vector;
  integervector = ^TInternalVectorRecordVector;
  TConsensusRecord = record
     name: string[255];
     NumbOfFactors: integer;
     ConsMatVector: matrixvector;
  end;
  var
    consensusRec: TConsensusRecord;

  procedure CreateDestroy(Create:boolean; n:integer; var v:matrixvector); overload;
  procedure CreateDestroy(Create:boolean; n:integer; var v:integervector); overload;

var
  consensusForm: TconsensusForm;

implementation

uses
  uSimplePlot;
{$R *.dfm}
type
     TpIntArray=array[1..maxword] of tcolor;

  var
      factorindex: integer;

procedure TconsensusForm.PaintCoph(Sender: TObject);
var
  MyBitmap: TBitmap;
  i: integer;
  v: vector;
  min: double;
begin
      create1(consensusRec.NumbOfFactors, v);
      min := 1;
      for i:= 1 to consensusRec.NumbOfFactors do begin
        v.v[i] := consensusRec.ConsMatvector[i].Coph;
        if min > v.v[i] then min := v.v[i];
      end;
      MinLabel.Caption:=FloatToStrF(min, ffFixed, 4, 4);
      SimplePlot3(consensusRec.NumbOfFactors,v,image2.Width,image2.Height,factorindex, true, MyBitMap);
      destroy1(v);
      Image2.Picture.Graphic := MyBitmap;
      image2.Refresh;
      MyBitmap.Free;
end;


procedure TconsensusForm.PaintImage(Sender: TObject);
var
  MyBitmap: TBitmap;
  c: TColor;
  ttt:^TpIntArray;
  ii, jj, aux, counteri, counterj, i,j,wi, restwi, newi, newj: integer;
  aw, bw: extended;
begin
      MyBitmap := TBitmap.Create;
      MyBitmap.Width := image1.Width;
      MyBitmap.Height := image1.Height;
      MyBitmap.PixelFormat:=pf32bit;
      Image1.Picture.Graphic := MyBitmap;
      FactorLabel.Caption:='Number of Factors: ' + inttostr(consensusRec.ConsMatvector[factorindex].K);
      CophLabel.Caption:='Cophenetic correlation coefficient: ' + FloatToStrF(consensusRec.ConsMatvector[factorindex].Coph, ffFixed, 4, 4);
      wi :=  image1.Picture.Bitmap.Height div consensusRec.ConsMatvector[factorindex].mat.nr;
      restwi := image1.Picture.Bitmap.Height mod consensusRec.ConsMatvector[factorindex].mat.nc;
      if (wi = 0) then begin
         // Do downsampling
        bw := (consensusRec.ConsMatvector[factorindex].mat.nr-1)/(image1.Width-1);
        aw := 1-bw;
      end;
      
      // Now paint Bitmap
      counteri:= 0; i:=1;
      for ii:= 1 to image1.Height-1 do begin
        ttt:=image1.Picture.Bitmap.scanline[ii-1];
        if (wi = 0) then begin
              i := round(aw + bw*ii);
        end else begin
            counteri := counteri +1;
            if (i <= restwi) then  begin
                if (counteri = (wi+1)) then begin
                        i:=i+1;
                        counteri := 0;
                    end;
                end else begin
                    if (counteri = wi) then begin
                        i:=i+1;
                        counteri := 0;
                    end;
                end;
            j := 1; counterj := 0;
        end;
        for jj:=1 to image1.Width-1 do begin
            if (wi = 0) then begin
                j := round(aw + bw*jj);
            end else begin
                counterj := counterj +1;
                if (j <= restwi) then  begin
                    if (counterj = (wi+1)) then begin
                        j:=j+1;
                        counterj := 0;
                    end;
                end else begin
                    if (counterj = wi) then begin
                        j:=j+1;
                        counterj := 0;
                    end;
                end;
            end;
            newi := consensusRec.ConsMatvector[factorindex].index.v[i];
            newj := consensusRec.ConsMatvector[factorindex].index.v[j];
            masky.v[ii] := newi;
            maskx.v[jj] := newj;
            aux:= round(255*(consensusRec.ConsMatvector[factorindex].mat.m[newi,newj]));
            c:=rgb(0, 0, aux);
            ttt^[jj]:=c;
        end;
      end;
      image1.Refresh;
      MyBitmap.Free;
end;


procedure TconsensusForm.FormShow(Sender: TObject);
var
  i: integer;
begin
  create1(image1.Height, masky);
  create1(image1.Width, maskx);
  for i:=1 to maskx.n do maskx.v[i]:=1;
  for i:=1 to masky.n do masky.v[i]:=1;
  paintImage(Sender);
  PaintCoph(Sender);
end;

procedure CreateDestroy(Create:boolean; n:integer; var v:matrixvector);
begin
  if create then
    getmem(v,n*sizeof(TMatrixRecord))
  else
    freemem(v,n*sizeof(TMatrixRecord))
end;

procedure CreateDestroy(Create:boolean; n:integer; var v:integervector);
begin
  if create then
    getmem(v,n*sizeof(vector))
  else
    freemem(v,n*sizeof(vector))
end;

procedure TconsensusForm.FormCreate(Sender: TObject);
begin
  factorindex :=1;
end;

procedure TconsensusForm.nextButClick(Sender: TObject);
begin
   if (factorindex < consensusRec.NumbOfFactors) then begin
      factorindex := factorindex +1;
      previousBut.Enabled := true;
      PaintImage(Sender);
      PaintCoph(Sender);
      Image1.Repaint;
      Image2.Repaint;
   end;
   if (factorindex = consensusRec.NumbOfFactors) then
       nextBut.Enabled := false;
end;

procedure TconsensusForm.PreviousButClick(Sender: TObject);
begin
   if (factorindex > 1) then begin
      factorindex := factorindex -1;
      nextBut.Enabled := true;
      PaintImage(Sender);
      PaintCoph(Sender);
      Image1.Repaint;
      Image2.Repaint;
   end;
   if (factorindex = 1) then
       previousBut.Enabled := false;
end;

procedure TconsensusForm.Image1MouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
  // take the coordinates for the mouse and display labels
  x := x+1; y:=y+1;
  vlabel.Caption := 'Variable label (' + inttostr(masky.v[y]) + ','  + inttostr(maskx.v[x]) + ') : (' + varlabels^[numberofrowheaders+masky.v[y]] + ', ' +  varlabels^[numberofrowheaders+maskx.v[x]] + ')';
  Classlabel.Caption := 'Variable cluster (' + inttostr(masky.v[y]) + ','  + inttostr(maskx.v[x]) + ') : (' + inttostr(consensusRec.ConsMatvector[factorindex].indexcluster.v[masky.v[y]]) + ', ' +  inttostr(consensusRec.ConsMatvector[factorindex].indexcluster.v[maskx.v[x]]) + ')';
end;

procedure TconsensusForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  factorindex :=1;
  nextBut.Enabled := true;
  previousBut.Enabled := false;
  destroy1(maskx);
  destroy1(masky);
end;

procedure TconsensusForm.saveconsensusClick(Sender: TObject);
var
  S: string;
  FileExt :string[4];
  Save_Cursor:TCursor;
begin
  // Save bitmap
  if savedialog1.Execute then begin
    S := savedialog1.FileName;
    FileExt := AnsiUpperCase(ExtractFileExt(S));
    if (FileExt <> '.BMP') then S := S + '.bmp';
    if FileExists(S) then
      if MessageDlg(S+' Exists. Overwrite?',mtConfirmation,[mbYes, mbNo],0) = mrNo then exit;
    Save_Cursor := Screen.Cursor;
    Screen.Cursor := crHourGlass;    // Show hourglass cursor
    Image1.Picture.Bitmap.SavetoFile(S);
    Screen.Cursor := Save_Cursor;  // Always restore to normal
  end;
end;

procedure TconsensusForm.savecophClick(Sender: TObject);
var
  S: string;
  FileExt :string[4];
  Save_Cursor:TCursor;
begin
  // Save bitmap
  if savedialog1.Execute then begin
    S := savedialog1.FileName;
    FileExt := AnsiUpperCase(ExtractFileExt(S));
    if (FileExt <> '.BMP') then S := S + '.bmp';
    if FileExists(S) then
      if MessageDlg(S+' Exists. Overwrite?',mtConfirmation,[mbYes, mbNo],0) = mrNo then exit;
    Save_Cursor := Screen.Cursor;
    Screen.Cursor := crHourGlass;    // Show hourglass cursor
    Image2.Picture.Bitmap.SavetoFile(S);
    Screen.Cursor := Save_Cursor;  // Always restore to normal
  end;
end;

end.
