{***************************************************************************
 *
 * Author:     Alberto Pascual Montano (pascual@fis.ucm.es)
 *             http://www.dacya.ucm.es/apascual

 * Complutense University of Madrid (UCM). Madrid, Spain
 * The KEY Institute for Brain-Mind Research, Zurich, Switzerland
 * National Center for Biotechnology (CNB). Madrid, Spain
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 *  All comments concerning this program package may be sent to the
 *  e-mail address 'pascual@fis.ucm.es'
 ***************************************************************************}
 
unit interfaceUnit;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, ComCtrls, Menus, processUnit;

type
  TForm1 = class(TForm)
    GroupBox1: TGroupBox;
    InFnTxt: TEdit;
    OpenButt: TButton;
    CheckOpenButt: TButton;
    GroupBox2: TGroupBox;
    OutFnTxt: TEdit;
    SaveButt: TButton;
    CheckSaveButt: TButton;
    GroupBox3: TGroupBox;
    varfolding: TRadioButton;
    objsfolding: TRadioButton;
    StatusBar1: TStatusBar;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    OverWriteCheck: TCheckBox;
    MainMenu1: TMainMenu;
    Go1: TMenuItem;
    ReuseChk: TCheckBox;
    Button1: TButton;
    addmin: TRadioButton;
    expscal: TRadioButton;
    dontdo: TRadioButton;
    CheckBox2: TCheckBox;
    PageControl: TPageControl;
    stdNMF: TTabSheet;
    Biclustering: TTabSheet;
    SampleClassification: TTabSheet;
    stdNumbOfFact: TLabeledEdit;
    biNumbOfFact: TLabeledEdit;
    stdSmoothness: TLabeledEdit;
    biSmoothness: TLabeledEdit;
    stdNumbOfIter: TLabeledEdit;
    biNumbOfIter: TLabeledEdit;
    stdStopping: TLabeledEdit;
    biStopping: TLabeledEdit;
    stdNumbOfRuns: TLabeledEdit;
    stdRadioCombine: TRadioButton;
    stdRadioSaveAllRuns: TRadioButton;
    biNumbOfRuns: TLabeledEdit;
    biCheckSaveAllRuns: TCheckBox;
    clasMinimumNumbOfFactors: TLabeledEdit;
    clasSparseness: TLabeledEdit;
    clasNumbOfIter: TLabeledEdit;
    clasNumbOfRuns: TLabeledEdit;
    clasMaxNumbOfFactors: TLabeledEdit;
    minimizeCheck: TCheckBox;
    CancelButton: TButton;
    Label1: TLabel;
    ComboBox1: TComboBox;
    procedure OpenButtClick(Sender: TObject);
    procedure CheckOpenButtClick(Sender: TObject);
    procedure SaveButtClick(Sender: TObject);
    procedure CheckSaveButtClick(Sender: TObject);
    procedure Go1Click(Sender: TObject);
    procedure ReuseChkClick(Sender: TObject);
    procedure PageControlChange(Sender: TObject);
    procedure CancelButtonClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    function CheckOpen:boolean;
    function CheckSave:boolean;
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.OpenButtClick(Sender: TObject);
begin
  if opendialog1.Execute then
    InFnTxt.Text:=opendialog1.FileName;
end;

function TForm1.CheckOpen:boolean;
begin
  CheckOpen:=false;
  if InFnTxt.Text='' then begin
    showmessage('Select a data matrix');
    InFnTxt.SetFocus;
    exit;
  end;
  if not FileExists(InFnTxt.Text) then begin
    showmessage('Data matrix file does not exist');
    InFnTxt.SetFocus;
    exit;
  end;
  CheckOpen:=true;
end;

procedure TForm1.CheckOpenButtClick(Sender: TObject);
begin
  if CheckOpen then
    showmessage('OK: data matrix file exists');
end;

procedure TForm1.SaveButtClick(Sender: TObject);
begin
  if savedialog1.Execute then
    OutFnTxt.Text:=changefileext(savedialog1.FileName,'');
end;

function TForm1.CheckSave:boolean;
var fn:string; f:textfile; ioerr:boolean;
begin
  CheckSave:=false;
  OutFnTxt.Text:=changefileext(OutFnTxt.Text,'');
  if OutFnTxt.Text='' then begin
    showmessage('Select an output (save) file name');
    OutFnTxt.SetFocus;
    exit;
  end;

  fn:=OutFnTxt.Text+'-info.txt';
  if not OverWriteCheck.Checked then
    if FileExists(fn) then
      if MessageDlg(fn+' Exists. Overwrite?',mtConfirmation,[mbYes, mbNo],0) = mrNo then begin
        showmessage('Redefine output (save) file name');
        OutFnTxt.SetFocus;
        exit;
      end;

  fn:=OutFnTxt.Text+'-H.txt';
  if not OverWriteCheck.Checked then
    if FileExists(fn) then
      if MessageDlg(fn+' Exists. Overwrite?',mtConfirmation,[mbYes, mbNo],0) = mrNo then begin
        showmessage('Redefine output (save) file name');
        OutFnTxt.SetFocus;
        exit;
      end;

  fn:=OutFnTxt.Text+'-W.txt';
  if not OverWriteCheck.Checked then
    if FileExists(fn) then
      if MessageDlg(fn+' Exists. Overwrite?',mtConfirmation,[mbYes, mbNo],0) = mrNo then begin
        showmessage('Redefine output (save) file name');
        OutFnTxt.SetFocus;
        exit;
      end;

  fn:=OutFnTxt.Text+'-XXX666.txt';
  ioerr:=false;
  AssignFile(F, fn);
  try
    filemode:=1;
    rewrite(f);
    writeln(f,'1');
    closefile(f);
    erase(f);
  except
    on EInOutError do
      ioerr:=true;
  end;
  if ioerr then begin
    showmessage('Incorrect output (save) file name');
    OutFnTxt.SetFocus;
    exit;
  end;
  CheckSave:=true;
end;

procedure TForm1.CheckSaveButtClick(Sender: TObject);
begin
  if CheckSave then
    showmessage('OK: output (save) file name');
end;

procedure TForm1.Go1Click(Sender: TObject);
var nq,maxiter, sparsePower:integer;
    eps1,sparse,nosparse:extended;
    negmethod, numberOfRuns: integer;
    minNF, maxNF: integer;
begin

  CancelOption := false;
  if not CheckOpen then exit;
  if not CheckSave then exit;
  // method to treat negative data

  negmethod := 0;
  if (varfolding.Checked) then
    negmethod := 1
  else if (objsfolding.Checked) then
    negmethod := 2
  else if (addmin.Checked) then
    negmethod := 3
  else if (expscal.Checked) then
    negmethod := 4;

  MyStatusBar:= @StatusBar1;


  if PageControl.ActivePageIndex = 0 then begin // STANDARD NMF
      NQ:=strtointdef(stdNumbOfFact.text,0);
      if (NQ<=0) then begin
        showmessage('Incorrect input (# rows/columns for code vectors)');
        stdNumbOfFact.SetFocus;
        exit;
      end;

      eps1:=strtofloatdef(stdStopping.text,0);
      if eps1<0 then begin
        showmessage('Incorrect input (Stopping threshold)');
        stdStopping.SetFocus;
        exit;
      end;

      MaxIter:=strtointdef(stdNumbOfIter.text,0);

      sparse:=strtofloatdef(stdSmoothness.text,0);
      if (sparse<0) or (sparse>=1)then begin
        showmessage('Incorrect input (Non-smoothness), it should be >= 0 and < 1');
        stdSmoothness.SetFocus;
        exit;
      end;
      nosparse:=1-sparse;

      sparsePower:= 1;

      numberOfRuns:=strtointdef(stdNumbOfRuns.text,0);
      if (numberOfRuns<1)then begin
        showmessage('Incorrect input (Number of runs)');
        stdNumbOfRuns.SetFocus;
        exit;
      end;

      If (ReuseChk.Checked) then numberOfRuns:=1;

      Button1.Enabled := false;
      CancelButton.Enabled := true;      
      if stNMF(InFnTxt.Text,OutFnTxt.Text,ReuseChk.Checked, true,nq,maxiter,sparsePower,eps1,sparse,nosparse, negmethod, true, checkbox2.checked, stdRadioSaveAllRuns.Checked,numberOfRuns, ComboBox1.ItemIndex, minimizecheck.Checked) then
         showmessage('Finished!');
      myStatusBar^.SimpleText := ' Finished ';
      Button1.Enabled := true;
      CancelButton.Enabled := false;      

  end else if PageControl.ActivePageIndex = 1 then begin // BICLUSTERING
      NQ:=strtointdef(biNumbOfFact.text,0);
      if (NQ<=0) then begin
        showmessage('Incorrect input (# rows/columns for code vectors)');
        biNumbOfFact.SetFocus;
        exit;
      end;

      eps1:=strtofloatdef(biStopping.text,0);
      if eps1<0 then begin
        showmessage('Incorrect input (Stopping threshold)');
        biStopping.SetFocus;
        exit;
      end;

      MaxIter:=strtointdef(biNumbOfIter.text,0);

      sparse:=strtofloatdef(biSmoothness.text,0);
      if (sparse<0) or (sparse>=1)then begin
        showmessage('Incorrect input (Non-smoothness), it should be >= 0 and < 1');
        biSmoothness.SetFocus;
        exit;
      end;
      nosparse:=1-sparse;

      sparsePower:= 1;

      numberOfRuns:=strtointdef(biNumbOfRuns.text,0);
      if (numberOfRuns<1)then begin
        showmessage('Incorrect input (Number of runs)');
        biNumbOfRuns.SetFocus;
        exit;
      end;

      If (ReuseChk.Checked) then numberOfRuns:=1;

      Button1.Enabled := false;
      CancelButton.Enabled := true;
      biNMF(InFnTxt.Text,OutFnTxt.Text,ReuseChk.Checked,
           true,nq,maxiter,sparsePower,eps1,sparse,nosparse, negmethod, true, checkbox2.checked, biCheckSaveAllRuns.checked,numberOfRuns, ComboBox1.ItemIndex, minimizecheck.Checked);
      myStatusBar^.SimpleText := ' Finished ';
      Button1.Enabled := true;
      CancelButton.Enabled := false;

  end else if PageControl.ActivePageIndex = 2 then begin // SAMPLE CLASSIFICATION

      maxNF:=strtointdef(clasMaxNumbOfFactors.text,0);
      if (maxNF<=0) then begin
        showmessage('Incorrect input (# rows/columns for code vectors)');
        clasMaxNumbOfFactors.SetFocus;
        exit;
      end;

      minNF:=strtointdef(clasMinimumNumbOfFactors.text,0);
      if (minNF<=0) then begin
        showmessage('Incorrect input (# rows/columns for code vectors)');
        clasMinimumNumbOfFactors.SetFocus;
        exit;
      end;

      if (minNF>maxNF) then begin
        showmessage('Incorrect number of factors');
        clasMinimumNumbOfFactors.SetFocus;
        exit;
      end;

      MaxIter:=strtointdef(clasNumbOfIter.text,0);

      sparse:=strtofloatdef(clasSparseness.text,0);
      if (sparse<0) or (sparse>=1)then begin
        showmessage('Incorrect input (Non-smoothness), it should be >= 0 and < 1');
        clasSparseness.SetFocus;
        exit;
      end;
      nosparse:=1-sparse;

      sparsePower:= 1;

      numberOfRuns:=strtointdef(clasNumbOfRuns.text,0);
      if (numberOfRuns<1)then begin
        showmessage('Incorrect input (Number of runs)');
        clasNumbOfRuns.SetFocus;
        exit;
      end;

      If (ReuseChk.Checked) then numberOfRuns:=1;

      Button1.Enabled := false;
      CancelButton.Enabled := true;
      classNMF(InFnTxt.Text,OutFnTxt.Text,ReuseChk.Checked,
           true,minNF, maxNF,maxiter,sparsePower,sparse,nosparse, negmethod, true, checkbox2.checked, biCheckSaveAllRuns.checked,numberOfRuns, ComboBox1.ItemIndex, minimizecheck.Checked);
      myStatusBar^.SimpleText := ' Finished ';
      Button1.Enabled := true;
      CancelButton.Enabled := false;      
  end;

end;

procedure TForm1.ReuseChkClick(Sender: TObject);
begin
  If (ReuseChk.Checked) then begin
     biNumbOfRuns.Enabled := false;
     stdNumbOfRuns.Enabled := false;
     stdRadioCombine.Enabled := false;
     stdRadioSaveAllRuns.Enabled := false;
     biCheckSaveAllRuns.Enabled := false;
  end else begin
     biNumbOfRuns.Enabled := true;
     stdNumbOfRuns.Enabled := true;
     stdRadioCombine.Enabled := true;
     stdRadioSaveAllRuns.Enabled := true;
     biCheckSaveAllRuns.Enabled := true;
  end;
end;

procedure TForm1.PageControlChange(Sender: TObject);
begin
  if PageControl.ActivePageIndex = 2 then begin
     varfolding.Enabled := false;
     objsfolding.Enabled := false;
     ReuseChk.Checked := false;
     ReuseChk.Enabled := false;
     if (varfolding.Checked or objsfolding.Checked) then
        dontdo.Checked := true;
  end else begin
     varfolding.Enabled := true;
     objsfolding.Enabled := true;
     ReuseChk.Enabled := true;
  end;
end;

procedure TForm1.CancelButtonClick(Sender: TObject);
begin
  CancelOption := true;
end;

end.

