{***************************************************************************
 *
 * Author:     Alberto Pascual Montano (pascual@fis.ucm.es)
 *             http://www.dacya.ucm.es/apascual

 * Complutense University of Madrid (UCM). Madrid, Spain
 * The KEY Institute for Brain-Mind Research, Zurich, Switzerland
 * National Center for Biotechnology (CNB). Madrid, Spain
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 *  All comments concerning this program package may be sent to the
 *  e-mail address 'pascual@fis.ucm.es'
 ***************************************************************************}

unit uSimplePlot;

interface

uses graphics, uMatToolsDyn;

procedure SimplePlot2(n:integer;
                      var y: vector; // array [1..m] of double, m>=n
                      w1,h1:integer; // width and height of bitmap
                      ii:integer; // index for special value y[ii]
                      var bm:TBitMap // returns plot in bitmap
                      );
{
Vector y holds n values, in range 0-1. Vector y must have been declared in
main program as array[1..m] of double, with m larger or equal to n. Assumes x
axis values are equispaced. The ii-th element of y (y[ii]) is painted with
different color. This will create the bitmap, so don't create it yourself,
and when finished with it, you must make "bm.free" to destroy and free memory.
}

procedure SimplePlot3(n:integer; // n>1
                      var y: vector; // array [1..m] of double, m>=n
                      w1,h1:integer; // width and height of bitmap
                      ii:integer; // index for special value y[ii]
                      scale:boolean;
                      var bm:TBitMap // returns plot in bitmap
                      );
{
Vector y holds n values, in range 0-1. Vector y must have been declared in
main program as array[1..m] of double, with m larger or equal to n. Assumes x
axis values are equispaced. The ii-th element of y (y[ii]) is painted with
different color. This will create the bitmap, so don't create it yourself,
and when finished with it, you must make "bm.free" to destroy and free memory.
If scale=false then min=0. If scale=true then uses true min(y).
Max=1 always.
}

implementation

uses types,math;

procedure SimplePlot2(n:integer; // n>1
                      var y: vector; // array [1..m] of double, m>=n
                      w1,h1:integer; // width and height of bitmap
                      ii:integer; // index for special value y[ii]
                      var bm:TBitMap // returns plot in bitmap
                      );
{
Vector y holds n values, in range 0-1. Vector y must have been declared in
main program as array[1..m] of double, with m larger or equal to n. Assumes x
axis values are equispaced. The ii-th element of y (y[ii]) is painted with
different color. This will create the bitmap, so don't create it yourself,
and when finished with it, you must make "bm.free" to destroy and free memory.
}

// range checking off !!
{$R-}

var tr:trect; LeftMargin,RightMargin,TopMargin,BottomMargin:integer;
    x0,dx,y0,dy,x1:extended; i,DotSize:integer;
begin

  bm := TBitmap.Create;
  bm.Width := w1;
  bm.Height := h1;
  bm.PixelFormat:=pf24bit;

  bm.canvas.brush.color:=clwhite; // background color
  bm.canvas.pen.color:=clblue; // pen color
  bm.canvas.pen.Width:=1; // pen width

  tr.Left:=0;
  tr.Right:=w1;
  tr.Top:=0;
  tr.Bottom:=h1;
  bm.canvas.fillrect(tr);

  // margins here. change at will
  LeftMargin:=10;
  RightMargin:=10;
  TopMargin:=10;
  BottomMargin:=10;

  tr.Left:=LeftMargin;
  tr.Right:=w1-RightMargin;
  tr.Top:=TopMargin;
  tr.Bottom:=h1-BottomMargin;
  bm.canvas.rectangle(tr); // draws axes as a box

  x0:=LeftMargin;
  dx:=(w1-LeftMargin-RightMargin)/(n-1.0);
  dy:=(h1-TopMargin-BottomMargin-2);
  y0:=h1-BottomMargin-1-y.v[1]*dy;

  bm.canvas.pen.Width:=2; // pen width
  bm.Canvas.MoveTo(round(x0),round(y0));
  x1:=x0;
  for I := 2 to n do begin
    x1:=x1+dx;
    y0:=h1-BottomMargin-1-y.v[i]*dy;
    bm.Canvas.lineto(round(x1-1),round(y0));
  end;

  x0:=LeftMargin;
  dx:=(w1-LeftMargin-RightMargin)/(n-1.0);
  dy:=(h1-TopMargin-BottomMargin-2);

  DotSize:=4;
  x1:=x0;
  for I := 1 to n do begin
    y0:=h1-BottomMargin-1-y.v[i]*dy;
    bm.Canvas.moveto(round(x1-1),round(y0));
    if i=ii then begin
      bm.canvas.pen.color:=clred; // pen color
      bm.canvas.brush.color:=clred; // background color
    end else begin
      bm.canvas.pen.color:=clblue; // pen color
      bm.canvas.brush.color:=clblue; // background color
    end;

    bm.Canvas.Ellipse(round(x1-1-DotSize),round(y0-DotSize),round(x1-1+DotSize),round(y0+DotSize));
    x1:=x1+dx;
  end;

end;




procedure SimplePlot3(n:integer; // n>1
                      var y: vector; // array [1..m] of double, m>=n
                      w1,h1:integer; // width and height of bitmap
                      ii:integer; // index for special value y[ii]
                      scale:boolean;
                      var bm:TBitMap // returns plot in bitmap
                      );
{
Vector y holds n values, in range 0-1. Vector y must have been declared in
main program as array[1..m] of double, with m larger or equal to n. Assumes x
axis values are equispaced. The ii-th element of y (y[ii]) is painted with
different color. This will create the bitmap, so don't create it yourself,
and when finished with it, you must make "bm.free" to destroy and free memory.
If scale=false then min=0. If scale=true then uses true min(y).
Max=1 always.
}

// range checking off !!
{$R-}

var tr:trect; LeftMargin,RightMargin,TopMargin,BottomMargin:integer;
    x0,dx,y0,dy,x1,min1,yyy:extended; i,DotSize:integer;
begin

  if not scale then
    min1:=0
  else begin
    min1:=1.0e30;
    for i:=1 to n do
      min1:=min(min1,y.v[i]);
    if min1=1 then
      min1:=0;
  end;

  bm := TBitmap.Create;
  bm.Width := w1;
  bm.Height := h1;
  bm.PixelFormat:=pf24bit;

  bm.canvas.brush.color:=clwhite; // background color
  bm.canvas.pen.color:=clblack; // pen color
  bm.canvas.pen.Width:=1; // pen width

  tr.Left:=0;
  tr.Right:=w1;
  tr.Top:=0;
  tr.Bottom:=h1;
  bm.canvas.fillrect(tr);

  // margins here. change at will
  LeftMargin:=10;
  RightMargin:=10;
  TopMargin:=10;
  BottomMargin:=10;

  tr.Left:=LeftMargin;
  tr.Right:=w1-RightMargin;
  tr.Top:=TopMargin;
  tr.Bottom:=h1-BottomMargin;
  bm.canvas.rectangle(tr); // draws axes as a box

  x0:=LeftMargin;
  dx:=(w1-LeftMargin-RightMargin)/(n-1.0);
  dy:=(h1-TopMargin-BottomMargin-2);
  yyy:=(y.v[1]-min1)/(1-min1);
  y0:=h1-BottomMargin-1-yyy*dy;

  bm.canvas.pen.Width:=2; // pen width
  bm.Canvas.MoveTo(round(x0),round(y0));
  x1:=x0;
  for I := 2 to n do begin
    x1:=x1+dx;
    yyy:=(y.v[i]-min1)/(1-min1);
    y0:=h1-BottomMargin-1-yyy*dy;
    bm.Canvas.lineto(round(x1-1),round(y0));
  end;

  x0:=LeftMargin;
  dx:=(w1-LeftMargin-RightMargin)/(n-1.0);
  dy:=(h1-TopMargin-BottomMargin-2);

  DotSize:=4;
  x1:=x0;
  for I := 1 to n do begin
    if i=ii then begin
      bm.canvas.pen.color:=clred; // pen color
      bm.canvas.brush.color:=clred; // background color
    end else begin
      bm.canvas.pen.color:=clblack; // pen color
      bm.canvas.brush.color:=clblack; // background color
    end;
    yyy:=(y.v[i]-min1)/(1-min1);
    y0:=h1-BottomMargin-1-yyy*dy;
    bm.Canvas.Ellipse(round(x1-1-DotSize),round(y0-DotSize),round(x1-1+DotSize),round(y0+DotSize));
    x1:=x1+dx;
  end;

{$R+}
// restore range checking

end;




end.
