{***************************************************************************
 *
 * Author:     Alberto Pascual Montano (pascual@fis.ucm.es)
 *             http://www.dacya.ucm.es/apascual

 * Complutense University of Madrid (UCM). Madrid, Spain
 * The KEY Institute for Brain-Mind Research, Zurich, Switzerland
 * National Center for Biotechnology (CNB). Madrid, Spain
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 *  All comments concerning this program package may be sent to the
 *  e-mail address 'pascual@fis.ucm.es'
 ***************************************************************************}

unit utilityUnit;

interface

uses processUnit, uMatToolsDyn;

PROCEDURE HEAPSORT1(N:INTEGER; VAR A:VECTOR; var iA:intvector);

implementation




PROCEDURE HEAPSORT(N:INTEGER; VAR A:VECTOR); // descending order
VAR L,R:INTEGER; X:extended;

  PROCEDURE SIFT;
  VAR	I,J:INTEGER; P:BOOLEAN;
  BEGIN { SIFT }
    P:=TRUE;
    I:=L;
    J:=2*I;
    X:=A.v[I];
    WHILE (J<=R) AND P DO BEGIN
      IF J<R THEN
        IF A.v[J]>A.v[J+1] THEN // < for ascending order
          J:=J+1;
      IF X>A.v[J] THEN BEGIN  // < for ascending order
        A.v[I]:=A.v[J];
        I:=J;
        J:=I*2
      END ELSE
       P:=FALSE
    END;
    A.v[I]:=X
  END; { SIFT	}

BEGIN	{ HEAPSORT }
  L:=(N DIV 2)+1;
  R:=N;
  WHILE L>1 DO BEGIN
    L:=L-1;
    SIFT
  END;
  WHILE R>1 DO BEGIN
    X:=A.v[1];
    A.v[1]:=A.v[R];
    A.v[R]:=X;
    R:=R-1;
    SIFT
  END
END; { HEAPSORT }




PROCEDURE HEAPSORT1(N:INTEGER; VAR A:VECTOR; var iA:intvector);
// descending order; sorts iA according to A. iA is typically 1..N, the "order".
VAR L,R:INTEGER; X:extended; iX:word;

  PROCEDURE SIFT;
  VAR	I,J:INTEGER; P:BOOLEAN;
  BEGIN { SIFT }
    P:=TRUE;
    I:=L;
    J:=2*I;
    X:=A.v[I]; iX:=iA.v[i];
    WHILE (J<=R) AND P DO BEGIN
      IF J<R THEN
        IF A.v[J]>A.v[J+1] THEN // < for ascending order
          J:=J+1;
      IF X>A.v[J] THEN BEGIN  // < for ascending order
        A.v[I]:=A.v[J]; iA.v[I]:=iA.v[J];
        I:=J;
        J:=I*2
      END ELSE
       P:=FALSE
    END;
    A.v[I]:=X; iA.v[I]:=iX
  END; { SIFT	}

BEGIN	{ HEAPSORT }
  L:=(N DIV 2)+1;
  R:=N;
  WHILE L>1 DO BEGIN
    L:=L-1;
    SIFT
  END;
  WHILE R>1 DO BEGIN
    X:=A.v[1]; iX:=iA.v[1];
    A.v[1]:=A.v[R]; iA.v[1]:=iA.v[R];
    A.v[R]:=X; iA.v[R]:=iX;
    R:=R-1;
    SIFT
  END
END; { HEAPSORT }




end.
