#!/usr/bin/python
############################################################################
## DeltaStat v0.2.0
##
## Copyright 2004 Jason Dunsmore
##
##    This file is part of DeltaStat.
##
##    DeltaStat is free software; you can redistribute it and/or modify
##    it under the terms of the GNU General Public License as published by
##    the Free Software Foundation; either version 2.1 of the License, or
##    (at your option) any later version.
##
##    DeltaStat is distributed in the hope that it will be useful,
##    but WITHOUT ANY WARRANTY; without even the implied warranty of
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##    GNU General Public License for more details.
##
##    You should have received a copy of the GNU General Public License
##    along with DeltaStat; if not, write to the Free Software
##    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
##
## This program will query the database to get columns from spots that
## satisfy certain criteria and perform a 2 sample t-test on the control
## and treated groups.
##

from rpy import *
import MySQLdb, cgi
import cgitb; cgitb.enable()

form = cgi.FieldStorage()

exp_date = form['exp_date'].value

general_conditions = 'WHERE ' + form['freq_gel'].value + ' ' + form['freq_operator'].value + ' ' + form['freq_number'].value + '\nAND ' + form['rstd_grp'].value + ' ' + form['rstd_operator'].value + ' ' + form['rstd_number'].value

# Conditions of database query for analyses. 
conditions = {1: general_conditions + '\nAND `ratio mean norm Volume experimental / mean norm Volume control` ' + form['foldchange_operator1'].value + ' ' + form['foldchange_number1'].value + '\nAND ' + form['normvol_pos_grp'].value + ' ' + form['normvol_pos_operator'].value + ' ' + form['normvol_pos_number'].value,
              2: general_conditions + '\nAND `ratio mean norm Volume experimental / mean norm Volume control` ' + form['foldchange_operator2'].value + ' ' + form['foldchange_number2'].value + '\nAND ' + form['normvol_neg_grp'].value + ' ' + form['normvol_neg_operator'].value + ' ' + form['normvol_neg_number'].value}

# Join *_allGels and *_statistics tables
query = 'SELECT %s, %s FROM `%s_allGels` LEFT JOIN `%s_statistics` \nUSING ( NUMBER ) %s \nGROUP BY `ctrl4 ID`'

# Fields to query from the database.
fields = '`ctrl1 ID`, `average norm Volume of group control`, `relative standard deviation of group control`, `average norm Volume of group experimental`, `relative standard deviation of group experimental`, `ratio mean norm Volume experimental / mean norm Volume control`, MAX(`number of spots in row of group control`)'

# Create dictionaries for query
ctrl_replicates = {1: '`norm volume ctrl1`',
                   2: '`norm volume ctrl1`, `norm volume ctrl2`',
                   3: '`norm volume ctrl1`, `norm volume ctrl2`, `norm volume ctrl3`',
                   4: '`norm volume ctrl1`, `norm volume ctrl2`, `norm volume ctrl3`, `norm volume ctrl4`'}

exp_replicates = {1: '`norm volume exp1`',
                  2: '`norm volume exp1`, `norm volume exp2`',
                  3: '`norm volume exp1`, `norm volume exp2`, `norm volume exp3`',
                  4: '`norm volume exp1`, `norm volume exp2`, `norm volume exp3`, `norm volume exp4`'}

# Print head of html template
print "Content-Type: text/html\n\n"
print "<html>"
print "<head>"
print "  <title>DeltaStat</title>"
print "</head>"
print "<body>"
if form['print_output'].value == 'text':
    print "<pre>"

# Print header with experiment title and legend
if form['print_output'].value == 'text':
    print '\n2D-Gel experiment from', exp_date
else:
    print '<h1>2D-Gel experiment from', exp_date, '</h1>'

# Initialize incremental variable (for label column).
label = 0

# Performs calculations and formats data
def analysis(n):
    global label

    # Connect to database and initialize dababase cursor
    db=MySQLdb.connect(host="localhost", user="your_username", passwd="your_pass",
    db="2d-gels")
    cursor=db.cursor()
    
    # Query normalized volume from database with support for variable
    # numbers of replicates
    try: cursor.execute(query % (ctrl_replicates[4], fields, exp_date, exp_date, conditions[n])); len_ctrl=4
    except MySQLdb.Error, e:
        try: cursor.execute(query % (ctrl_replicates[3], fields, exp_date, exp_date, conditions[n])); len_ctrl=3
        except MySQLdb.Error, e:
            try: cursor.execute(query % (ctrl_replicates[2], fields, exp_date, exp_date, conditions[n])); len_ctrl=2
            except MySQLdb.Error, e:
                print "You need more than one control replicate for a t-test"
    data1=cursor.fetchall()

    try: cursor.execute(query % (exp_replicates[4], fields, exp_date, exp_date, conditions[n])); len_exp=4
    except MySQLdb.Error, e:
        try: cursor.execute(query % (exp_replicates[3], fields, exp_date, exp_date, conditions[n])); len_exp=3
        except MySQLdb.Error, e:
            try: cursor.execute(query % (exp_replicates[2], fields, exp_date, exp_date, conditions[n])); len_exp=2
            except MySQLdb.Error, e:
                print "You need more than one trial for a t-test."
    data2=cursor.fetchall()
        
    data=zip(data1,data2)

    # Perform t-test using R via rpy.  Put the results in list pvalues.
    pvalues = []
    for tupleslice in data:
        fullstats = r.t_test(tupleslice[0][0:len_ctrl],tupleslice[1][0:len_exp])
        pvalues.extend([[fullstats['p.value'], tupleslice[1][len_exp], tupleslice[1][len_exp+1], tupleslice[1][len_exp+2], tupleslice[1][len_exp+3], tupleslice[1][len_exp+4], tupleslice[1][len_exp+5]]])

    # Sorted output by p-value
    pvalues.sort()

    if form['print_output'].value == 'html':
        print "<table border=\"1\" width=\"100%\">"
        
    # Print header as either text or html formatted
    if form['print_output'].value == 'text':
        print '\nAnalysis', n, '\n\nConditions:\n', conditions[n], '\nAND `p-value` <', form['pvalue_number'].value, '\n\nlabel  ctrl1ID p-value    ctrlAve  ctrlRstd  expAve  expRstd  expVol/ctrlVol'
    else:
        print '<h2>Analysis', n, '</h2>Conditions:<br>', "<pre>", conditions[n], '<br>AND `p-value` <', form['pvalue_number'].value, "</pre>", '''<tr>
        <th></th>
        <th>label</th>
        <th>ctrl1ID</th>
        <th>p-value</th>
        <th>ctrlAve</th>
        <th>ctrlRstd</th>
        <th>expAve</th>
        <th>expRstd</th>
        <th>expVol/ctrlVol</th>
        </tr>'''

    # Print results results as either text or html formatted
    if form['print_output'].value == 'text':
        for value in pvalues:
            if float(value[0]) < float(form['pvalue_number'].value) and value[1] != 0:
                label += 1
                print "%3d   %5d    %8f   %5.3f   %5.2f      %5.3f   %5.2f   %6.3f" % (label, value[1], float(value[0]), value[2], value[3], value[4], value[5], value[6])
        print '\n'
    else:
        for value in pvalues:
            if float(value[0]) < float(form['pvalue_number'].value) and value[1] != 0:
                label += 1
                print '''<tr>
                <td align=\"center\" width=\"45\">
                    <form name=\"input\" method=\"get\" action=\"boxplot.py\">
                    <input type=\"hidden\" name=\"boxplot_id\" value=\"%5d\">
                    <input type=\"hidden\" name=\"ctrl_replicates\" value=\"%s\">
                    <input type=\"hidden\" name=\"exp_replicates\" value=\"%s\">
                    <input type=\"hidden\" name=\"exp_date\" value=\"%s\">
                    <input type=\"hidden\" name=\"len_ctrl\" value=\"%1d\">
                    <input type=\"hidden\" name=\"len_exp\" value=\"%1d\">
                    <input type=\"hidden\" name=\"label\" value=\"%3d\">
                    <button type=\"submit\"><img src=\"../boxplot.jpg\" border=\"0\"></button>
                    </form></td>
                <td align=\"center\">%3d</td>
                <td align=\"center\">%5d</td>
                <td align=\"center\">%8f</td>
                <td align=\"center\">%5.3f</td>
                <td align=\"center\">%5.2f</td>
                <td align=\"center\">%5.3f</td>
                <td align=\"center\">%5.2f</td>
                <td align=\"center\">%6.3f</td></tr>''' % (value[1], ctrl_replicates[len_ctrl], exp_replicates[len_exp], exp_date, len_ctrl, len_exp, label, label, value[1], float(value[0]), value[2], value[3], value[4], value[5], value[6])
        print '<br>'

    if form['print_output'].value == 'html':
        print "</table>"
                
# Execute function for analyses 1 & 2
analysis(1)
analysis(2)

# Print legened as either text or html formatted
if form['print_output'].value == 'text':
    print '''Legend:
label = Label the spots in Delta2D according to this column.  
p-value = P-values calculated from a 2-sample ttest (ctrl group vs exp group).
ctrlXID = ID of spot on control gel X.
ctrlAve = Average intensity of the spot in the control group.
ctrlRstd = Relative standard deviation of the spot in the control group.
expAve = Average intensity of the spot in the experimental group.
expRstd = Relative standard deviation of the spot in the experimental group.
expVol/ctrlVol = ratio of mean % Volume experimental / mean % Volume control.
</pre>
'''
else:
    print '''<br><h2>Legend</h2>
label = Label the spots in Delta2D according to this column.<br>
p-value = P-values calculated from a 2-sample ttest (ctrl group vs exp group).<br>
ctrlXID = ID of spot on control gel X.<br>
ctrlAve = Average intensity of the spot in the control group.<br>
ctrlRstd = Relative standard deviation of the spot in the control group.<br>
expAve = Average intensity of the spot in the experimental group.<br>
expRstd = Relative standard deviation of the spot in the experimental group.<br>
expVol/ctrlVol = ratio of mean % Volume experimental / mean % Volume control.<br>
'''

# Bottom of html template
print "</body>"
print "</html>"
