package similarityValue;

import similarityValue.Molecule;
import java.util.Iterator;

import java.lang.Math;

public class MoleculePairValue {
	//TODO: Make Alpha configurable
	static double Alpha = 1;
	
	public static double similarityValue(Molecule mol1, Molecule mol2) {
		similarityValuePart numerator = new similarityValuePart(mol1,mol2);
		similarityValuePart denomMolA = new similarityValuePart(mol1,mol1);
		similarityValuePart denomMolB = new similarityValuePart(mol2,mol2);
		Thread numeratorThread = new Thread(numerator);
		Thread denomMolAThread = new Thread(denomMolA);
		Thread denomMolBThread = new Thread(denomMolB);
		
		numerator.tid = "mol1, mol2 (" + numeratorThread.getId() + ")";
		denomMolA.tid = "mol1, mol1 (" + denomMolAThread.getId() + ")";
		denomMolB.tid = "mol2, mol2 (" + denomMolBThread.getId() + ")";
		
		numeratorThread.start();
		denomMolAThread.start();
		denomMolBThread.start();
		
		//TODO: How about some actual error handling?
		try {
			numeratorThread.join();
			denomMolAThread.join();
			denomMolBThread.join();
		}
		catch (InterruptedException e) {
			e.printStackTrace();
		}
		
		
		return (numerator.getResult() / (Math.sqrt(denomMolA.Result) * Math.sqrt(denomMolB.Result)));
	}
	
	public static class similarityValuePart implements Runnable {
		Molecule mol1, mol2;
		public boolean resultFound = false;
		public double Result = 0;
		public String tid;
		
		public similarityValuePart(Molecule mol1, Molecule mol2) {
			this.mol1 = mol1;
			this.mol2 = mol2;
		}
		
		public void run() {
			double curSum = 0;
			long OutputCount = 0;
			long StartTime = System.currentTimeMillis();
			
			Iterator<PotentialPoint> iter1 = mol1.iterator();
			PotentialPoint point1;
			Iterator<PotentialPoint> iter2;
			PotentialPoint point2;
			while (iter1.hasNext()) {
				point1 = iter1.next();
				
				iter2 = mol2.iterator();
				while (iter2.hasNext()) {
					point2 = iter2.next();
					
					curSum += point1.potential * point2.potential * Math.exp(-1 * Alpha * point1.point.distanceSquared(point2.point));
				}
				
				OutputCount++;
				if (OutputCount % 15 == 0) {
					double ElapsedTime = (System.currentTimeMillis() - StartTime) / 1000.0;
					System.out.println("Cur value: " + curSum + " at " + (OutputCount * 100.0 / mol1.getNumPoints()) + "% (" + OutputCount + " of " + mol1.getNumPoints() + ") after " + ElapsedTime + "s at " + (OutputCount/ElapsedTime) + "/s while processing " + this.tid);
				}
			}
			resultFound = true;
			Result = curSum; 
		}
		
		public boolean getResultFound() {
			return resultFound;
		}
		
		public double getResult() {
			return Result;
		}
	}
}
