#!/usr/bin/env perl

#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# This file is part of G-language Genome Analysis Environment package
#
#     Copyright (C) 2001-2007 Keio University
#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# 
#   $Id: Reader.pm,v 1.8 2002/04/01 14:19:54 t98901ka Exp $
#
# G-language GAE is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
# 
# G-language GAE is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public
# License along with G-language GAE -- see the file COPYING.
# If not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
# 
#END_HEADER
#

package G::SystemsBiology::Serizawa;

use File::Basename;

use SubOpt;
use G::Messenger;

use strict;
use vars qw($VERSION @ISA @EXPORT @EXPORT_OK);

require Exporter;

@ISA = qw(Exporter AutoLoader);
@EXPORT = qw(
	     ecell
	     ss2er
	     er2eri
);


__DATA__

#::::::::::::::::::::::::::::::
#        Methods Start
#::::::::::::::::::::::::::::::

sub ecell{
    my @args = opt_get(@_);
    my $gb = shift @args;
    my $r = opt_val("r");
    if (length $r){
	system("ecell -r $r &");
    }else{
	system("ecell &");
    }
}

sub ss2er{
    my $infile = shift;
    my ($base, $dir, $ext) = fileparse($infile, '\..*');

    system('ss2er < ' . $infile . ' > ' . $dir . $base . '.er');

    return $dir . $base . '.er';
}

sub er2eri{
    my $infile = shift;
    my ($base, $dir, $ext) = fileparse($infile, '\..*');

    system('er2eri ' . $infile . ' > ' . $dir . $base . '.eri');

    return $dir . $base . '.eri';
}



sub DESTROY {
    my $self = shift;
}

1;
__END__
# Below is the stub of documentation for your module. You better edit it!

=head1 NAME

G::Ecell::Serizawa - Perl extension for blah blah blah

=head1 SYNOPSIS

  use G::Ecell::Serizawa;
  blah blah blah

=head1 DESCRIPTION

Stub documentation for G::Ecell::Serizawa was created by h2xs. It looks like the
author of the extension was negligent enough to leave the stub
unedited.

Blah blah blah.

=head1 AUTHOR

Seira Nakamura, gaou@g-language.org

=head1 SEE ALSO

perl(1).

=cut
