#!/usr/bin/env perl

#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# This file is part of G-language Genome Analysis Environment package
#
#     Copyright (C) 2001-2007 Keio University
#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# 
#   $Id: SIM4.pm,v 1.2 2002/05/28 10:06:19 gaou Exp $
#
# G-language GAE is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
# 
# G-language GAE is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public
# License along with G-language GAE -- see the file COPYING.
# If not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
# 
#END_HEADER
#


package G::Tools::SIM4;


use SubOpt;
use G::Messenger;

use strict;
use vars qw($VERSION @ISA @EXPORT @EXPORT_OK);

use SelfLoader;

require Exporter;

@ISA = qw(Exporter AutoLoader);
@EXPORT = qw(

	     _sim4
	     mapping_sim4
	     form_sim4
	     );

__DATA__

#::::::::::::::::::::::::::::::
#        Methods Start
#::::::::::::::::::::::::::::::

sub _sim4{  
    &opt_default(qsub=>'off',input=>"file",output=>"STDOUT");
    my @param;
    my @tmp;

    foreach(@_){
        if(/[WXKCRDHAPNBS]\=\d/){
	    push(@param,$_);
        }
        else{
            push(@tmp,$_);
        }
    }
    @_=@tmp;

    my @args=opt_get(@_);

    my $qsub=&opt_val("qr");
    my $input=&opt_val("input");
 my $output=&opt_val("output");
    my $data;
    my $file;
    my $seq;
    my %opt;
    my $param;
    my $num;
    my $output_file=();
    $output_file = "> ".$output if($output ne "STDOUT");

    $data=shift @args;
    if($input eq 'seq'){
	$seq=shift @args;
	opendir(DIR,'/tmp');
	@tmp=readdir(DIR);
	$num=$#tmp+1+time;
	@tmp=keys(%$seq);
	open(FILE,'>/tmp/SIM4_'.$num.'.seq');
	print FILE ">$tmp[0]\n";
	print FILE $$seq{"$tmp[0]"},"\n";
	close(FILE);
	$file='/tmp/SIM4_'.$num.'.seq'; 
    }
    else{
	$file=shift @args;
    }

    $opt{W}=&opt_val("W");
    $opt{X}=&opt_val("X");
    $opt{K}=&opt_val("K");
    $opt{C}=&opt_val("C");
    $opt{R}=&opt_val("R");
    $opt{D}=&opt_val("D");
    $opt{H}=&opt_val("H");
    $opt{A}=&opt_val("A");
    $opt{P}=&opt_val("P");
    $opt{N}=&opt_val("N");
    $opt{B}=&opt_val("B");
    $opt{S}=&opt_val("S");

    foreach(sort keys(%opt)){
	next if($opt{$_} eq '');
	push(@param,$_.'=');
	push(@param,$opt{$_});
    }
    $param=join(' ',@param);

    system("sim4 $data $file @param $output_file")if($qsub eq "off");
   system('qr',"sim4 $data $file $param $output_file")if($qsub eq "on");

    unlink('/tmp/sim4'.$num.'.seq') if($input eq 'seq' && $qsub ne 'on');

    return("$data $file $param");
}



sub mapping_sim4{    
    &opt_default(seq1=>"",seq2=>"",output=>"SIM4_OUT");
    my @args=opt_get(@_);

    my $seq1=&opt_val("seq1");
    my $seq2=&opt_val("seq2");
    my $output=&opt_val("output");
    my $memory=shift @args;    
    
    #::::::::::::::::::::
    #        param
    #::::::::::::::::::::
    
    my @param;
    my @tmp;

    foreach(@_){
	if(/[WXKCRDHAPNBS]\=\d/){
	    push(@param,$_);
	}
	else{
	    push(@tmp,$_);
	}
    }
    @_=@tmp;
    
    my $seq;
    my %opt;
    my $param;
    my $num;
    my $sentence;
    $output = $output if($output ne "SIM4_OUT");
    
    $opt{W}=&opt_val("W");
    $opt{X}=&opt_val("X");
    $opt{K}=&opt_val("K");
    $opt{C}=&opt_val("C");
    $opt{R}=&opt_val("R");
    $opt{D}=&opt_val("D");
    $opt{H}=&opt_val("H");
    $opt{A}=&opt_val("A");
    $opt{P}=&opt_val("P");
    $opt{N}=&opt_val("N");
    $opt{B}=&opt_val("B");
    $opt{S}=&opt_val("S");
    
    foreach(sort keys(%opt)){
	next if($opt{$_} eq '');
	push(@param,$_.'=');
	push(@param,$opt{$_});
    }
    $param=join(' ',@param);
    
    if($seq1 ne "" && $seq2 ne ""){
	my $data;
	my $file;
	if(-f $seq1){
	    if(-f $seq2){
		$data = $seq1;
		$file = $seq2;
	        system("sim4 $data $file @param >> $output");
	    }
	}
	elsif(-d $seq2){
	    my (@file2,$num2,$h);
	    opendir(DIR2, "$seq2");
	    @file2 = readdir(DIR2);
	    $num2 = @file2;
	    for($h=2;$h<$num2;$h++){
		$data = $seq1;
		$file = "$seq2$file2[$h]";
		system("sim4 $data $file @param >> $output");
	    }
	}
	elsif(-d $seq1){
	    my (@file1,$num1,$i);
	    opendir(DIR1, "$seq1");
	    @file1 = readdir(DIR1);
	    $num1 = @file1;	
	    if(-f $seq2){
		for($i=2;$i<$num1;$i++){
		    $data = "$seq1$file1[$i]"; 
                    $file =$seq2;
		    system("sim4 $data $file @param >> $output");
		}
	    }
		      
	    elsif(-d $seq2){
		my(@file2,$num1,$num2,$i,$j);
		opendir(DIR2,"$seq2");
		@file2 = readdir (DIR2);
		$num2 = @file2;
		for($i=2;$i<$num1;$i++){
		    for($j=2;$j<$num2;$j++){
			$data = "$seq1$file1[$i]";
			$file = "$seq2$file2[$j]";
			system("sim4 $data $file @param >> $output");
		    }
		}
	    }
	}    
    }
    else{
	my ($bcount,$ccount);
	$bcount=0;
	$ccount=0;
	while(1){
	    if($memory->{$ccount}->{Query_Path}->{$bcount}=~ /\w/){ 
	        my $data;
		my $file;
		$data=$memory->{$ccount}->{Query_Path}->{$bcount};
		$file=$memory->{$ccount}->{Genome_Path}->{$bcount};
		system("sim4 $data $file @param >> $output");
		$bcount ++;
	    }		    
	    else{
		$bcount=0;
		$ccount++;	    
		if($memory->{$ccount}->{Query_Path}->{$bcount} eq ""){
		    last;
		}		
	    }
	}
    }
}

sub form_sim4{
    &opt_default(input=>"SIM4_OUT",output=>"SIM4_RESULT");
    my @args=opt_get(@_);
    my $input=&opt_val("input");
    my $output=&opt_val("output");
    my $memory=shift @args;
    
    $input = $input if($input ne "SIM4_OUT");
    $output = $output if($output ne "SIM4_RESULT");
    open(FILE,"$input");
    open(W_FILE,">$output");

    while(<FILE>){
	my (@sum1,@sum2,@aaa,@part,@z1,@w1,@w2);
	my ($wal,$m,$g,$data,$num,$n,$pos1,$pos2,$name,$moto);
	if($_ =~ /^seq1/){
        chomp;
        print W_FILE "-------------------------------------------------------------------------\n\n";
        @sum1 = split(/,/,$_);
        @sum2 = split(/ +/,$sum1[1]);
        $wal = $sum2[1];
        $_ =~ s/^seq1/cDNA  /g;
        print W_FILE "$_\n";
    }
    elsif($_ =~ /^seq2/){
        chomp;
        $_ =~ s/^seq2/cut   /g;
        print W_FILE "$_\n";
        @aaa = split(/\//,$_);
        $m=split(/\//,$_);
        $g=$m-1;
        $name = $aaa[$g];
        @part = split(/_/,$name);
        $data = $part[0];
        $num = $part[1];
        print W_FILE "contig = ";
	
	$moto=$memory->{Genome_ID};

        print W_FILE "$moto/$data\n";
    }
	elsif($_ =~ /^[0-9]/){
	    chomp;
	    @z1 = split(/ +/,$_);
	    @w1 = split(/-/,$z1[0]);
	    @w2 = split(/-/,$z1[1]);
	    $w2[0] =~ s/[^0-9]//g;
	    $w2[1] =~ s/[^0-9]//g;
	    $pos1 = $num + $w2[0] - 1;
	    $pos2 = $num + $w2[1] - 1;
        print W_FILE "$z1[0]\t$z1[1]\t<$pos1-$pos2>\t$z1[2]\t$z1[3]\n";
	}       
	else{
	    print W_FILE $_;
	}       
    }
}







sub DESTROY {
    my $self = shift;
}

1;

__END__







