# Load the Module::Install bundled in ./inc/
use inc::Module::Install;
    
# Define metadata
name            'g-language';
all_from        'lib/G/Skyline.pm';
abstract        'G-language Genome Analysis Environment package';
author          'Kazuharu Arakawa <gaou@g-language.org>';
license         'gpl';
perl_version    '5.006';


# Specific dependencies
requires        'Bio::Perl'                    =>   '0';
requires        'Chart::Graph::Gnuplot'        =>   '0';
requires        'DBI'                          =>   '0';
requires        'GD'                           =>   '0';
requires        'GD::Graph::bars'              =>   '0';
requires        'GD::Graph::lines'             =>   '0';
requires        'HTTP::Cookies'                =>   '0';
requires        'HTTP::Request::Common'        =>   '0';
requires        'LWP::Simple'                  =>   '0';
requires        'LWP::UserAgent'               =>   '0';
requires        'List::Compare'                =>   '0';
requires        'SOAP::Lite'                   =>   '0';
requires        'SVG'                          =>   '0';
requires        'Statistics::Descriptive'      =>   '2.6';
requires        'Statistics::LineFit'          =>   '0.06';
requires        'Statistics::RankCorrelation'  =>   '0.1';
requires        'Statistics::TTest'            =>   '1.1';
requires        'Statistics::DependantTTest'   =>   '0.03';
requires        'Statistics::Distributions'    =>   '1.02';
requires        'String::Approx'               =>   '0';
requires        'Term::ReadLine::Gnu'          =>   '0';
requires        'URI'                          =>   '0';
requires        'XML::Namespace'               =>   '0.02';
requires        'XML::Parser'                  =>   '0';
requires        'Graph::Layout::Aesthetic'     =>   '0';

requires_external_bin 'gnuplot';
requires_external_bin 'display';

build_requires   'Test::More'        => '0.42';
    
#no_index        'directory'         => 'demos';

install_script  'bin/G';
install_script  'bin/gimv';
    
auto_install;
WriteAll;
