/*
    Copyright (C) 2006  Laurent Poirrier

    This file is part of YGL2.

    YGL2 is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    YGL2 is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

*/

#ifndef __YTK_DRAW_H
#define __YTK_DRAW_H
#include "workspace.h"

unsigned int Ytk24ToColor(unsigned int c);
unsigned int YtkRGBToColor(int r, int g, int b);
void YtkColorToRGB(int *r, int *g, int *b, unsigned int c);

unsigned int YtkGetPixel(struct ytk_ws *ws, int x, int y);

void YtkPutPixel(struct ytk_ws *ws, int x, int y, unsigned int c);
void YtkVLine(struct ytk_ws *ws, int x, int y1, int y2, unsigned int c);
void YtkHLine(struct ytk_ws *ws, int x1, int x2, int y, unsigned int c);
void YtkRectangle(struct ytk_ws *ws, int x1, int y1, int x2, int y2,
	unsigned int c);
void YtkRectangleOutline(struct ytk_ws *ws, int x1, int y1, int x2, int y2,
	unsigned int c);
void YtkClear(struct ytk_ws *ws, unsigned int c);
void YtkGradient(struct ytk_ws *ws, int x1, int y1, int x2, int y2,
	unsigned int c1, unsigned int c2, int vertical);
void YtkLine(struct ytk_ws *ws, int x1, int y1, int x2, int y2,
	unsigned int c);

#endif
