#include <stdlib.h>
#include "fonts.h"
#include "embedded_font.h"

// 128x64 (P5 0-255) 1024 bytes
static unsigned int font_bitmap[256] = {
 0x0,0x2,0x10000000,0x280808,0x0,0x2,0x8000000,0x141008,0x3c343c1e,
 0x2222120e,0x83e2222,0x1008,0x20c2222,0x22221202,0x4102214,0x2008,
 0x1c042222,0x2a141202,0x8083c08,0x1008,0x20043c1e,0x2a141222,
 0x8042014,0x1008,0x1e042002,0x14082c1c,0x83e2222,0x1008,0x2002,
 0x0,0x10001c00,0x808,0x20008,0x380020,0x2000002,0x8,0x1c021c10,
 0x1c041c20,0x2000002,0x8,0x221e2000,0x2204223c,0x12100802,0x1c1c1608,
 0x2223c00,0x221c3e22,0x1200001e,0x22242a08,0x2222200,0x3c040222,
 0xe100822,0x22242a08,0x22222200,0x20042222,0x12100822,0x22242a08,
 0x1c1e5c00,0x22041c3c,0x12120822,0x1c242a18,0x0,0x1c000000,0xc0000,
 0x0,0x3c3e3c3e,0x4242423e,0x387e4242,0x101c02,0x42424242,0x42424208,
 0x8202442,0x281004,0x2424242,0x42424208,0x8101824,0x441004,0x3c3e423e,
 0x42244208,0x8081018,0x1008,0x40124202,0x42244208,0x8081024,0x1010,
 0x42225202,0x5a184208,0x8041042,0x1010,0x3c423c02,0x24183c08,
 0x87e1042,0x1020,0x2000,0x0,0x38000000,0x7e001c00,0x3c3e1800,
 0x3c7e7e1e,0x42200842,0x3c424202,0x4242243c,0x42020222,0x22200042,
 0x42466602,0x2424232,0x2020242,0x12200842,0x424a5a02,0x23e422a,
 0x721e1e42,0xe20087e,0x42524202,0x2427e3a,0x42020242,0x12200842,
 0x42524202,0x42424202,0x42020222,0x22220842,0x42624202,0x3c3e423c,
 0x3c027e1e,0x421c0842,0x3c42427e,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
 0x0,0x1818101c,0x3c383c10,0x1818,0x18000000,0x24241822,0x20040418,
 0x2424,0x24080010,0x1020142a,0x101c1c14,0x8082418,0x20103c08,
 0x2010102a,0x8242012,0x3824,0x10200004,0x24081022,0x824243e,0x2024,
 0x103c08,0x183c101c,0x4181810,0x8081c18,0x10080010,0x0,0x0,0x4000000,
 0x0,0x14140000,0x80c4208,0x420,0x20000000,0x14140800,0x812253c,
 0x80810,0x10000000,0x3e000800,0x12120a,0x82a1008,0x10000000,0x14000800,
 0xc081c,0x81c1008,0x8000000,0x3e000800,0x2a2428,0x3e1c1008,0x4003e00,
 0x14000000,0x125228,0x82a1008,0x4000000,0x14000800,0x2c211e,0x8080810,
 0x2080010,0x0,0x8,0x420,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
 0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
 0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2a,
 0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x22,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
 0x2a,0x0,0x0,0x0,0x0,0x0,0x0,0x0 };

static unsigned char *gray_data = (unsigned char *)0;
static struct ytk_font *embedded_font;
static int use_count = 0;

struct ytk_font *YtkEmbeddedFont()
{
	unsigned int n, b, v;
	unsigned char *dst;

	if (use_count > 0) {
		use_count++;
		return(embedded_font);
	}

	gray_data = malloc(sizeof(font_bitmap)*8);
	if (!gray_data) return(NULL);

	dst = gray_data;
	for (n=0; n<256; n++) {
		v = font_bitmap[n];
		for (b=0; b<32; b++) {
			*dst = (v & (1<<b)) ?  255 : 0;
			dst++;
		}
	}

	embedded_font = YtkFontInit(gray_data, 128, 64);
	if (!embedded_font) {
		free(gray_data);
		return(NULL);
	}

	use_count++;
	return(embedded_font);
}

void YtkFreeEmbeddedFont(struct ytk_font *fnt)
{
	use_count--;
	if (use_count > 0) return;
	YtkFontFree(fnt);
	free(gray_data);
}

