/*
    Copyright (C) 2006  Laurent Poirrier

    This file is part of YGL2.

    YGL2 is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    YGL2 is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

*/

#include "internal.h"
#include "glx.h"

struct ygl_glx_t ygl_glx;

void YInit_glx()
{
	int v, r;
	
	ygl_glx.available = ygl_glx.verrel = 0;
	
	if (!glXQueryExtension(ygl.display, &v, &v)) {
		PE("\tglX: not available\n");
		return;
	}
	glXQueryVersion(ygl.display, &v, &r);
	PE("\tglX: %d.%d\n", v, r);
	ygl_glx.available = 1;
	ygl_glx.verrel = (v<<16) | r;
}

void YClose_glx()
{
}

GLXContext YCreateGLXContext(int *attribs)
{
	XVisualInfo *vis;
	GLXContext r;
	
	vis = glXChooseVisual(ygl.display, ygl.screen, attribs);
	if (!vis) return(NULL);
	r = glXCreateContext(ygl.display, vis, NULL, True);
	if (r) {
		XFree(vis);
		return(r);
	}

	// XXX to remove when tested with indirect rendering contexts:
	// glXCreateContext(..., True) should also return indirect contexts
	r = glXCreateContext(ygl.display, vis, (GLXContext)0, False);
	XFree(vis);
	if (r) {
		PE("Warning: Can't create glX context when asking for\n"
		"\tdirect rendering if possible\n");
		return(r);
	}
	return((GLXContext)0);
}
