/*
    Copyright (C) 2006  Laurent Poirrier

    This file is part of YGL2.

    YGL2 is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    YGL2 is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

*/

#ifndef __YGL_GLX_H
#define __YGL_GLX_H
#include "display.h"
#include <GL/glx.h>

extern struct ygl_glx_t {
	int available;
	int verrel;
} ygl_glx;

void YInit_glx();
void YClose_glx();
GLXContext YCreateGLXContext(int *attribs);

/*
Memo:
	XVisualInfo *XGetVisualInfo(ygl.display, mask, template, int *nb);
	glXGetConfig(ygl.display, XVisualInfo *, int attrib, int *val);
	-- or --
	XVisualInfo *glXChooseVisual(ygl.display, ygl.screen, int *attribs);
	
	GLXContext glXCreateContext(ygl.display,
		XVisualInfo *,
		GLXContext share_display_lists:NULL,
		direct:True/False);
	
	glXDestroyContext(ygl.display, GLXContext);
	glXIsDirect(ygl.display, GLXContext);
	glXMakeCurrent(ygl.display, GLXDrawable, GLXContext);
	glXSwapBuffers(ygl.display, window);
*/
#endif
