#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include "../mformat/pnm.h"

#define PE(s...)	fprintf(stderr, s)

#define FILE_GRAIN	262144
char *file_buffer;
int file_size;

int read_file(int fd)
{
	int n;

	file_buffer = NULL;
	file_size = 0;
	while(1) {
		file_buffer = realloc(file_buffer, file_size+FILE_GRAIN);
		if (!file_buffer) {
			PE("realloc(%d): %s\n",
				file_size+FILE_GRAIN, strerror(errno));
			return(-1);
		}
		
		n = read(fd, file_buffer+file_size, FILE_GRAIN);
		if (n == 0) return(0);
		if (n < 0) {
			PE("read(): %s\n", strerror(errno));
			return(-1);
		}
		file_size += n;
	}
}

int main(int argc, char **argv)
{
	int iw, ih, imv, ip, n;
	unsigned char *ibuff;
	int isize, nints, lp;

	if (read_file(0)) return(1);

	if (pnm_info(file_buffer, &iw, &ih, &imv, &ip, file_size) == NULL) {
		PE("Not a pnm file\n");
		return(1);
	}

	isize = ((iw+7)>>3)*ih;
	ibuff = malloc(isize);
	if (!ibuff) {
		PE("malloc(%d): %s\n", isize, strerror(errno));
		return(1);
	}

	n = pnm_read(ibuff, M_BITMAP_LE, file_buffer, file_size);
	if (n < 0) { PE("Incomplete pnm file\n"); return(1); }

	printf("// %dx%d (P%d 0-%d) %d bytes:\n", iw, ih, ip, imv, isize);

	nints = (isize+3)/4;
	printf("unsigned int pnmfile[%d] = {\n ", nints);

	lp = 0;
	for (n=0; n<nints; n++) {
		lp += printf("0x%x", ((unsigned int *)ibuff)[n]);
		if (n != (nints-1)) lp += printf(",");
		if (lp > 60) { printf("\n "); lp = 0; }
	}
	printf("};\n\n");

	PE("// OK\n");
	return(0);
}

