/*
    Copyright (C) 2006  Laurent Poirrier

    This file is part of YGL2.

    YGL2 is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    YGL2 is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

*/

#include "internal.h"
#include "vidmode.h"

struct ygl_vidmode_t ygl_vm;

void YInit_xf86vidmode()
{
	int v, r;
		
	ygl_vm.nmodes = 0;
	ygl_vm.modes = (XF86VidModeModeInfo **)0;
	
	if (!XF86VidModeQueryExtension(ygl.display, &v, &v))
		{ PE("\tXF86VidMode: not available\n"); return; }
	
	if (!XF86VidModeGetAllModeLines(ygl.display, ygl.screen,
	&ygl_vm.nmodes, &ygl_vm.modes))
		{ PE("\tXF86VidMode: Can't get modeline info\n"); return; }
	
	if (ygl_vm.nmodes < 0) ygl_vm.nmodes = 0;
	XF86VidModeQueryVersion(ygl.display, &v, &r);
	PE("\tXF86VidMode: %d.%d, modelines: %d\n", v, r, ygl_vm.nmodes);
}

void YClose_xf86vidmode()
{
	int t;
	
	if (ygl_vm.nmodes) {
		for (t=0; t<ygl_vm.nmodes; t++) if (ygl_vm.modes[t]->privsize)
			XFree(ygl_vm.modes[t]->private);
		XFree(ygl_vm.modes);
		//XF86VidModeLockModeSwitch(ygl.display, ygl.screen, 0);
	}
}

