/*
    Copyright (C) 2006  Laurent Poirrier

    This file is part of YGL2.

    YGL2 is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    YGL2 is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

*/

#include "ytk.h"

extern void YtkInit_workspaces();

int YtkInit()
{
	if (YInit()) return(-1);

	YInit_xshm();
	YInit_xvideo();

	// private
	YtkInit_workspaces();
	return(0);
}

void YtkClose()
{
	YClose_xshm();
	YClose_xvideo();
	YClose();
}

int YtkGetPressed(int wait, Window *w, int *x, int *y)
{
	XEvent e;

	while(1) {
		if (!wait) {
			if (XPending(ygl.display) == 0) return(0);
		}

		XNextEvent(ygl.display, &e);

		if (e.type == KeyPress) {
			if (w) *w = e.xkey.window;
			if (x) *x = e.xkey.x;
			if (y) *y = e.xkey.y;
			return(e.xkey.keycode);
		}

		if (e.type == ButtonPress) {
			if (w) *w = e.xbutton.window;
			if (x) *x = e.xbutton.x;
			if (y) *y = e.xbutton.y;
			return(-e.xbutton.button);
		}

		if ((e.type == Expose) && (e.xexpose.count == 0)) return(0);
	}
}

