#include "dga.h"

struct ygl_dga_t ygl_dga;

void YInit_dga()
{
	int ver, rel;
	
	ygl_dga.nmodes = 0;
	if (!XDGAQueryExtension(ygl.display, &ver, &ver)) {
		PE("\tDGA: not available\n");
		return;
	}
	XDGAQueryVersion(ygl.display, &ver, &rel);
	ygl_dga.modes = XDGAQueryModes(ygl.display, ygl.screen,
		&ygl_dga.nmodes);
	if (!ygl_dga.modes) ygl_dga.nmodes = 0;
	if (ygl_dga.nmodes <= 0) {
		PE("\tDGA: %d.%d, no modes available\n", ver, rel);
		return;
	}
	PE("\tDGA: %d.%d, modes: %d\n", ver, rel, ygl_dga.nmodes);
}

void YClose_dga()
{
	XFree(ygl_dga.modes);
}


