#include "gly.h"

struct ygl_glx_t ygl_glx;

void YInit_glx()
{
	int v, r;
	
	ygl_glx.available = ygl_glx.verrel = 0;
	
	if (!glXQueryExtension(ygl.display, &v, &v)) {
		PE("\tglX: not available\n");
		return;
	}
	glXQueryVersion(ygl.display, &v, &r);
	PE("\tglX: %d.%d\n", v, r);
	ygl_glx.available = 1;
	ygl_glx.verrel = (v<<16) | r;
}

void YClose_glx()
{
}

GLXContext YCreateGLXContext(int attrib0, ...)
{
	XVisualInfo *vis;
	GLXContext r;
	
	vis = glXChooseVisual(ygl.display, ygl.screen, &attrib0);
	if (!vis) return((GLXContext)0);
	r = glXCreateContext(ygl.display, vis, (GLXContext)0, True);
	if (r) return(r);
	
	// XXX to remove when tested with indirect rendering contexts:
	// glXCreateContext(..., True) should also return indirect contexts
	r = glXCreateContext(ygl.display, vis, (GLXContext)0, False);
	if (r) {
		PE("Warning: Can't create glX context when asking for\n"
		"\tdirect rendering if possible\n");
		return(r);
	}
	return((GLXContext)0);
}
