#ifndef __YGL2_WINDOW_H
#define __YGL2_WINDOW_H
#include "display.h"

Cursor YCreateCursor(char *data, int w, int h, int cx, int cy,
	float r1, float g1, float b1, float r2, float g2, float b2);
void YSetName(Window w, char *name, char *icon_name);

/*
Memo:
	// Setup window attributes
	unsigned long attrmask;
	XSetWindowAttributes attr;
	
	attrmask = CWBackPixmap|CWBackingStore|CWOverrideRedirect
		|CWSaveUnder|CWEventMask;
	attr.background_pixmap = None;
	attr.backing_store = NotUseful;
	attr.override_redirect = dont_use_wm_decorations;
	attr.save_under = False;
	attr.event_mask = KeyPressMask|KeyReleaseMask|ButtonPressMask
		|ButtonReleaseMask|PointerMotionMask|KeymapStateMask
		|EnterWindowMask|LeaveWindowMask|FocusChangeMask
		|ExposureMask|StructureNotifyMask;

	// Create window
	w = XCreateWindow(ygl.display, ygl.root_window, x, y, w, h, border_w:0,
		ygl.depth, InputOutput, ygl.default_visual, attrmask, &attr);
	if (w == None) ERROR();
	
	// Setup window
	if (use_window_manager) {
		XSizeHints sz_hints;
		XSizeHints *sz_hints_p;
		
		if (specify_size_range) {
			sz_hints.flags = PMinSize|PMaxSize;
			sz_hints.min_width = ; sz_hints.max_width = ;
			sz_hints.min_height= ; sz_hints.max_height= ;
			sz_hints_p = &sz_hints;
		} else	sz_hints_p = NULL;
		
		XmbSetWMProperties(ygl.display, win->w, name, icon_name,
			NULL, 0, sz_hints_p, NULL, NULL);
	}
	
	// Sync
	XMapRaised(ygl.display, w);
	XSync(ygl.display, False);
	
	// XMoveWindow(ygl.display, window, x, y);
	// XResizeWindow(ygl.display, window, w, h);
	// XCopyArea(ygl.display, w_src, w_dst,
	//	ygl.default_gc, x, y, w, h, dx, dy);
	// XDestroyWindow(ygl.display, window);
	// XGetGeometry(ygl.display, drawable, int *root, int *x, int *y,
	//	int *w, int *h, int *border, int *depth);
	
	// Cursor:
	XDefineCursor(ygl.display, Window, Cursor);
	XFlush(ygl.display);
	XFreeCursor(ygl.display, Cursor);

*/

#endif
