#include <stdlib.h>
#include "xv.h"

struct ygl_xv_t ygl_xv;

void YInit_xvideo()
{
	struct ygl_xv_port_t *p;
	int ver, rel, t, n;
	
	ygl_xv.nadaptors = ygl_xv.nports = 0;
	
	if (XvQueryExtension(ygl.display, &ver, &rel, &t, &t, &t)!=Success) {
		PE("\tXVideo: not available\n");
		return;
	}
	
	if (XvQueryAdaptors(ygl.display, ygl.root_window,
	&ygl_xv.nadaptors, &ygl_xv.adaptors) != Success) {
		PE("\tXVideo: can't get adaptor info\n");
		ygl_xv.nadaptors = 0;
		return;
	}
	
	if (ygl_xv.nadaptors <= 0) {
		PE("\tXVideo: %d.%d, no adaptor found\n", ver, rel);
		ygl_xv.nadaptors = 0;
		return;
	}
		
	for (t=0; t<ygl_xv.nadaptors; t++)
		ygl_xv.nports += ygl_xv.adaptors[t].num_ports;
	
	ygl_xv.ports = (struct ygl_xv_port_t *)
		malloc(ygl_xv.nports * sizeof(struct ygl_xv_port_t));
	if (!ygl_xv.ports) {
		PE("\tXVideo: %d ports; memory lack!\n", ygl_xv.nports);
		ygl_xv.nadaptors = ygl_xv.nports = 0;
		return;
	}
	
	p = ygl_xv.ports;
	for (t=0; t<ygl_xv.nadaptors; t++)
	for (n=0; n<ygl_xv.adaptors[t].num_ports; n++) {
		p->id = ygl_xv.adaptors[t].base_id + n;
		p->adaptor = &ygl_xv.adaptors[t];
		p->formats = XvListImageFormats(ygl.display,
			p->id, &p->nformats);
		if (!p->formats) p->nformats = 0;
		if (XvQueryEncodings(ygl.display, p->id,
		&p->nencodings, &p->encodings)!=Success) {
			p->nencodings = 0;
			p->encodings = (XvEncodingInfo *)0;
		}
		p++;
	}
	PE("\tXVideo: %d.%d, adaptors: %d, total ports: %d\n",
		ver, rel, ygl_xv.nadaptors, ygl_xv.nports);
	
}


void YClose_xvideo()
{
	int p;
	
	if (ygl_xv.nadaptors <= 0) return;
	XvFreeAdaptorInfo(ygl_xv.adaptors);
	
	if (ygl_xv.nports <= 0) return;
	
	for (p=0; p<ygl_xv.nports; p++) {
		if (ygl_xv.ports[p].nencodings)
			XvFreeEncodingInfo(ygl_xv.ports[p].encodings);
		if (ygl_xv.ports[p].nformats)
			XFree(ygl_xv.ports[p].formats);
	}
	free(ygl_xv.ports);
}



