#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include "buffers.h"

#define PE(s...)	fprintf(stderr, s)

static struct rb_channel_info {
	void *data;
	int rate, type;
	int size, idx;
} *rbc;

void rb_init(int channels)
{
	rbc = (struct rb_channel_info *)malloc(channels *
		sizeof(struct rb_channel_info));
	if (!rbc) {
		PE("rb_init(): Memory lack!\n");
		exit(1);
	}
}

void rb_setup(int channel, int rate, int type)
{
	rbc[channel].rate = rate;
	rbc[channel].type = type;
	rbc[channel].size = 8 * 3600 * rate;
	rbc[channel].idx = 0;
	rbc[channel].data = malloc(rbc[channel].size * type);
	if (!rbc[channel].data) {
		PE("rb_setup(): Memory lack (%d bytes)!\n",
			rbc[channel].size);
		exit(1);
	}
	PE("Allocated 8 hours data\n");
}

void rb_append(int channel, void *data, int samples)
{
	struct rb_channel_info *r;

	r = &rbc[channel];
	memcpy(r->data + (r->idx * r->type), data, samples * r->type);
	r->idx += samples;
}

void rb_last(int channel, float *dst, int samples)
{
	struct rb_channel_info *r;
	short *src;
	int t;

	r = &rbc[channel];
	if (r->type != 2) {
		PE("rb_last(): unimplemented function\n");
		return;
	}
	while (samples > r->idx) {
		*dst = 0;
		dst++;
		samples--;
	}
	src = ((short *)r->data) + r->idx - samples;
	for (t=0; t<samples; t++) {
		dst[t] = (float)(src[t]) / 32769.0;
	}
}

