#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include "YGL2/display.h"
#include "gui/dispatch.h"
#include "gui/draw.h"
#include "gui/manager.h"
#include "commands.h"
#include "rw.h"
#include "timer.h"
#include "fft.h"
#include "buffers.h"
#include "loop.h"


// **************************************************************
// 
// **************************************************************
static Window dw;
static void create_window()
{
	unsigned long attrmask;
	XSetWindowAttributes attr;
	
	if (YInit()) exit(1);
	
	attrmask = CWBackPixmap|CWBackingStore|CWSaveUnder|CWEventMask;
	attr.background_pixmap = None;
	attr.backing_store = NotUseful;
	attr.save_under = False;
	attr.event_mask = KeyPressMask|ButtonPressMask|PointerMotionMask
		|ButtonReleaseMask|ExposureMask|StructureNotifyMask;

	// Create window
	dw = XCreateWindow(ygl.display, ygl.root_window, 0, 0, 640, 480, 0,
		ygl.depth, InputOutput, ygl.default_visual, attrmask, &attr);
	if (dw == None) { PE("Can't create a window\n"); exit(1); }
	YSetName(dw, "gembla - GUI", "embla");
	XMapRaised(ygl.display, dw);
	XSync(ygl.display, False);
	
	return;
}

// **************************************************************
// 
// **************************************************************
static struct gui_ws ws;
static int nw, nh;
static int citems[6];
static int fitem, xitem;

static int caitem, doquit;
static int setac(int self, int v, void *p) { caitem = v; return(0); }
static int setoth(int self, int v, void *p) { doquit = 1; return(0); }

static void layout_init()
{
	int t, b, c, l, r;

	if (gui_set_theme(NULL)) return;
	if (gui_create_workspace(&ws, GUI_SHMPIXMAP|GUI_SHMIMAGE|GUI_IMAGE,
		640, 480)) exit(1);
	nw = ws.width; nh = ws.height;
	gui_set_target(&ws);
	
	gui_init_manager();

	b = gui_container(0, GUI_FULLWIDTH|GUI_SZ_MIN|GUI_PLACE_TOPL,
		5, GUI_BL_DIALOG);
	c = gui_container(0, GUI_FULLWIDTH|GUI_SZ_MIN|GUI_PLACE_BOTR,
		5, GUI_BL_DIALOG);
	gui_button(b, "Stop recording", 0);
	gui_button(b, "Exit", setoth);
	gui_button(c, "time scale", 0);
	gui_button(c, "voltage scale", 0);

	l = gui_container(0, GUI_FULLHEIGHT|GUI_SZ_PERCENT|GUI_PLACE_TOPL,
		70, GUI_BL_DIALOG|GUI_BL_CADRE);
	r = gui_container(0, GUI_FULLHEIGHT|GUI_SZ_REST, 0,
		GUI_BL_DIALOG|GUI_BL_CADRE);

	for (t=0;t<6;t++) {
		b = gui_container(l,
			GUI_FULLWIDTH|GUI_SZ_PERCENT|GUI_PLACE_TOPL,
			100/(6-t), GUI_BL_NONE);
		c = gui_button_ip(b, "R", setac, t, 0);
		citems[t] = gui_container(b, GUI_FULLHEIGHT|GUI_SZ_REST,
			0, GUI_BL_DRAW|GUI_BL_CADRE);
	}
	caitem = 0;
	doquit = 0;

	fitem = gui_container(r, GUI_FULLWIDTH|GUI_SZ_PERCENT|GUI_PLACE_TOPL,
		50, GUI_BL_DRAW|GUI_BL_CADRE);
	xitem = gui_container(r, GUI_FULLWIDTH|GUI_SZ_REST,0,
		GUI_BL_DRAW|GUI_BL_CADRE);
	gui_draw();
}

// **************************************************************
// 
// **************************************************************
static void layout_update(int wait)
{
	XEvent e;

	if ((!wait) && (!XPending(ygl.display))) return;
	do {
		XNextEvent(ygl.display, &e);
		if (e.type == MotionNotify)
			gui_mouseover(e.xmotion.x,e.xmotion.y,
				e.xmotion.state&Button1Mask);
		else if (e.type == ButtonPress)
			gui_mouseover(e.xbutton.x,e.xbutton.y,
				(e.xbutton.button==1));
		else if (e.type == ButtonRelease) {
			gui_mouseover(e.xbutton.x,e.xbutton.y, 0);
			gui_click(e.xbutton.x,e.xbutton.y);
		} else if (e.type == ConfigureNotify) {
			nw = e.xconfigure.width;
			nh = e.xconfigure.height;
		}
	} while (XPending(ygl.display));
	if ((nw!=ws.width)||(nh!=ws.height)) {
		gui_destroy_workspace(&ws);
		if (gui_create_workspace(&ws,
			GUI_SHMPIXMAP|GUI_SHMIMAGE|GUI_IMAGE,
			nw, nh)) return;
	}
	gui_draw();
}

// **************************************************************
// 
// **************************************************************
static void layout_exit()
{
	gui_close_manager();
	gui_theme.destroy();
	gui_destroy_workspace(&ws);
}

// **************************************************************
// 
// **************************************************************
#define POW	9
#define SAMPLES	(1<<10)
float alternate[SAMPLES*2];
float last[SAMPLES*2];
static void chan_display(int c)
{
	float *r;
	float v;
	int x,y,w,h, idx, dx, dy;

	rb_last(c, last, SAMPLES);
	gui_getpos(citems[c], &x,&y,&w,&h);
	idx = SAMPLES-w;
	while (idx<SAMPLES) {
		dy = (h>>1) + (last[idx]*(float)(h>>1));
		
		gui_putpixel(&ws, x,y+dy, gui_lcolor(0x0000ff));
		x++;
		idx++;
	}

	if (c != caitem) return;
	for (idx=0; idx<(SAMPLES<<1); idx++) {
		if (idx&1) alternate[idx] = 0;
		else alternate[idx] = last[idx>>1];
	}
	r = do_fft(alternate, last, POW, 1);
	
	gui_getpos(fitem, &x,&y,&w,&h);
	for (idx=0;idx<100;idx++) {
		dx = idx * w / 100;
		v = r[idx<<1];
		v *= v;
		dy = v * .01 * h;
		if (dy >= h) dy = h-1;
		gui_vline(&ws, x+dx, y+h-1-dy, y+h-1, gui_lcolor(0x0000ff));
	}
}

// **************************************************************
// 
// **************************************************************
unsigned char buff[256];
int mainloop(int fd_embla, int fd_video)
{
	unsigned char *b;
	int cmd, channel, samples, sz, subsz;

	timer_init();
	create_window();
	layout_init();
	gui_put_workspace(&ws, dw, 0, 0, 0, 0, ws.width, ws.height);
	XSync(ygl.display, False);
	
	rb_init(7);
	rb_setup(0, 100, 2); rb_setup(1, 100, 2);
	rb_setup(2, 100, 2); rb_setup(3, 100, 2);
	rb_setup(4, 200, 2); rb_setup(5, 200, 2);
	rb_setup(6, 10, 4);

	cmd = DRV_AQ_START;
	if (bwrite(fd_embla, &cmd, 4)) return(1);
	printf("Request for acquire... Waiting for reply...\n");
	if (bread(fd_embla, &cmd, 4)) return(1);
	if (cmd == 0) printf("Success. Acquire started.\n");
	else {
		printf("Failed.\n");
		return(1);
	}
	
	while (!doquit) {
		sz = 0;
		if (btread(fd_embla, &sz, 2, 1000)) return(1);
		if (sz > sizeof(buff)) {
			printf("Parse error on socket (buffer)\n");
			return(1);
		}
		if (btread(fd_embla, buff, sz, 1000)) return(1);
		b = buff;
		while (sz > 0) {
			channel = b[0];
			samples = b[1];
			subsz = (channel == 6) ? samples<<2 : samples<<1;
			if ((channel > 6) || (subsz > sz)) {
				printf("Parse error on socket (channel)\n");
				return(1);
			}
			rb_append(channel, b+2, samples);
			b += subsz + 2;
			sz -= subsz + 2;
		}
		
		layout_update(0);
		for (channel = 0; channel<6; channel++) {
			chan_display(channel);
		}
		gui_put_workspace(&ws, dw, 0, 0, 0, 0, ws.width, ws.height);
		XSync(ygl.display, False);
	}
	
	// Exit
	layout_exit();
	XDestroyWindow(ygl.display, dw);
	YClose();
	printf("Done\n");
	return(0);
}
