#include "rw.h"
#include "wav.h"

#define WAVE_RIFF	0x46464952
#define WAVE_WAVE	0x45564157
#define WAVE_fmt_	0x20746D66
#define WAVE_data	0x61746164

#define WAVE_MAXHEADER	512
#define WAVE_MAXCHUNK	256
int wav_readheader(int fd, struct wav_info *i)
{
	int h[2];
	int t[4];
	int done, got_fmt;

	if (mread(fd, t, 12)) return(-1);
	if (t[0] != WAVE_RIFF) return(-1);
	if (t[2] != WAVE_WAVE) return(-1);
	got_fmt = 0;
	done = 12;
	
	while(1) {
		if (mread(fd, h, 8)) return(-1);
		done += 8;
		if (h[0] == WAVE_fmt_) {
			if (h[1] < 16) return(-1);
			if (mread(fd, t, 16)) return(-1);
			done += 16;
			if ((t[0] & 0xffff) != 1) return(-1);
			if (i) {
				i->chans = t[0] >> 16;
				i->rate = t[1];
				i->bits = t[3] >> 16;
				i->sign = (i->bits <= 8);
			}
			h[1] -= 16;
			got_fmt = 1;
		} else if (h[0] == WAVE_data) {
			if (i) i->datasize = h[1];
			if (!got_fmt) return(-1);
			return(done);
		} // dismiss other chunks
		
		if (h[1] > WAVE_MAXCHUNK) return(-1); // security
		while (h[1] > 0) {
			if (h[1] > 16) {
				if (mread(fd, t, 16)) return(-1);
				done += 16;
				h[1] -= 16;
			} else {
				if (mread(fd, t, h[1])) return(-1);
				done += h[1];
				h[1] = 0;
			}
		}

		if (done > WAVE_MAXHEADER) return(-1); // security
	}
}

int wav_writeheader(int fd, struct wav_info *i)
{
	int t[11];

	if ((i->bits <= 8) != (i->sign == 0)) return(-1);
	t[0] = WAVE_RIFF;
	t[1] = i->datasize + 36;
	t[2] = WAVE_WAVE;
	t[3] = WAVE_fmt_;
	t[4] = 16;
	t[5] = (i->chans<<16) | 1;
	t[6] = i->rate;
	t[7] = i->rate * i->chans * ((i->bits+7) >> 3);
	t[8] = (i->bits<<16) | (i->chans * ((i->bits+7) >> 3));
	t[9] = WAVE_data;
	t[10] = i->datasize;
	if (mwrite(fd, t, 44)) return(-1);
	return(44);
}



