#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <sys/time.h>
#include <sys/times.h>
#include <sys/types.h>
#include <sys/select.h>
#include <sys/stat.h>
#include <fcntl.h>
#include "ipv46.h"

#define PE(s...)	fprintf(stderr, s)
#define EPE(s...)	fprintf(stderr, s, strerror(errno))

// ********************************************************************
// Defaults
// ********************************************************************
#define DEFAULT_IPVER	4
int ip_version = DEFAULT_IPVER;
#define DEFAULT_PORT	19101

// ********************************************************************
// Help
// ********************************************************************
void dumphelp()
{
	/*printf(
	"Usage: dgrams {-send|-receive} <address> [options]\n"
	"\t-send         Send datagrams to <address>\n"
	"\t-receive      Receive datagrams sent to <address>\n"
	"Options:\n"
	"\t-port=<x>     Port associated with <address>\n"
	"\t-filter=<x>   (receive) Only show datagrams sent by <x>\n"
	"\t-ipv4         Use IPv4 protocol%s\n"
	"\t-ipv6         Use IPv6 protocol%s\n",
	(DEFAULT_IPVER==4)?" (default)":"", (DEFAULT_IPVER==6)?" (default)":"");*/
	printf("Usage: dgrams {-send|-mirror} <address>\n");
}

// ********************************************************************
// Main
// ********************************************************************
int main(int argc, char **argv)
{
	fd_set rfd;
	struct ip_addr me, him;
	char addr[40];
	char buff[100];
	int sfd, n, r;

	ip_setipv(&me, ip_version);
	ip_setipv(&him, ip_version);

	sfd = socket(me.pf, SOCK_DGRAM, 0);
	if (sfd < 0) {
		EPE("Can't create datagram socket: %s\n");
		return(1);
	}

	if (argc != 3) { dumphelp(); return(1); }
	if (!strcmp(argv[1], "-send")) {
		ip_resolve(&him, argv[2]);
		ip_setport(&him, DEFAULT_PORT);
		while(1) {
			FD_ZERO(&rfd);
			FD_SET(0, &rfd);
			FD_SET(sfd, &rfd);
			select(sfd+1, &rfd, NULL, NULL, NULL);
			if (FD_ISSET(0, &rfd)) {
				n = read(0, buff, sizeof(buff)-1);
				if (n <= 0) return(0);
				r = sendto(sfd, buff, n, 0,
					&him.addr.gen, him.addrsize);
				if (r != n) EPE("Send error (%d/%d): %s\n", r, n);
			}
			if (FD_ISSET(sfd, &rfd)) {
				n = recvfrom(sfd, buff, sizeof(buff)-1, 0,
					&him.addr.gen, &him.addrsize);
				if (n <= 0) {
					EPE("Receive error: %s\n");
					return(1);
				}
				if (!ip_consistent(&him))
					PE("Received from wrong address family!\n");
				ip_addrtostr(addr, &him);
				buff[n] = 0;
				PE("< %s,%d: %d bytes: %s\n", addr,
					ip_getport(&him), n, buff);
			}
		}
	}
	if (!strcmp(argv[1], "-mirror")) {
		ip_resolve(&me, argv[2]);
		ip_setport(&me, DEFAULT_PORT);
		if (bind(sfd, &me.addr.gen, me.addrsize)) {
			EPE("Can't bind socket: %s\n");
			return(1);
		}
		while(1) {
			n = recvfrom(sfd, buff, sizeof(buff)-1, 0,
				&him.addr.gen, &him.addrsize);
			if (n <= 0) {
				EPE("Receive error: %s\n");
				return(1);
			}
			if (!ip_consistent(&him))
				PE("Received from wrong address family!\n");
			ip_addrtostr(addr, &him);
			buff[n] = 0;
			PE("< %s,%d: %d bytes: %s\n", addr, ip_getport(&him),
				n, buff);
			r = sendto(sfd, buff, n, 0,
				&him.addr.gen, him.addrsize);
			if (r != n) EPE("ReSend error: %s\n");
		}
	}
	dumphelp();
	return(1);
}
