#include <netdb.h>
#include <unistd.h>
#include <string.h>
#include "ipv46.h"

int ip_setipv(struct ip_addr *addr, int v)
{
	if (v==4) {
		addr->ipv = 4; addr->pf = PF_INET; addr->af = AF_INET;
		addr->addrsize = sizeof(struct sockaddr_in);
	} else if (v==6) {
		addr->ipv = 6; addr->pf = PF_INET6; addr->af = AF_INET6;
		addr->addrsize = sizeof(struct sockaddr_in6);
	} else return(-1);
	addr->addr.gen.sa_family = addr->af;
	return(0);
}

int ip_consistent(struct ip_addr *addr)
{
	if (addr->ipv == 4)
		return( (addr->pf == PF_INET) && (addr->af == AF_INET)
			&& (addr->addrsize == sizeof(struct sockaddr_in))
			&& (addr->addr.gen.sa_family == AF_INET) );
	if (addr->ipv == 6)
		return( (addr->pf == PF_INET6) && (addr->af == AF_INET6)
			&& (addr->addrsize == sizeof(struct sockaddr_in6))
			&& (addr->addr.gen.sa_family == AF_INET6) );
	return(0);
}

int ip_sameaddr(struct ip_addr *a1, struct ip_addr *a2)
{
	if (a1->ipv != a2->ipv) return(0);
	if (a1->ipv == 6)
		return(!memcmp(&a1->addr.v6.sin6_addr.s6_addr,
			&a2->addr.v6.sin6_addr.s6_addr, 16));
	return( a1->addr.v4.sin_addr.s_addr == a2->addr.v4.sin_addr.s_addr );
}

int ip_strtoaddr(struct ip_addr *addr, char *str)
{
	int r;

	str[IP_ADDRESS_STRING_SIZE-1] = 0;
	if (addr->ipv == 4)
		r = inet_pton(AF_INET, str, &addr->addr.v4.sin_addr);
	else if (addr->ipv == 6)
		r = inet_pton(AF_INET6, str, &addr->addr.v6.sin6_addr);
	else return(-1);
	if (r <= 0) return(-1);
	return(0);
}

int ip_addrtostr(char *str, struct ip_addr *addr)
{
	const char *r;
	
	if (addr->ipv == 4) r = inet_ntop(AF_INET, &addr->addr.v4.sin_addr,
		str, IP_ADDRESS_STRING_SIZE);
	else if (addr->ipv == 6) r = inet_ntop(AF_INET6,
		&addr->addr.v6.sin6_addr, str, IP_ADDRESS_STRING_SIZE);
	else r = (void *)-1;

	if (r) {
		str[IP_ADDRESS_STRING_SIZE-1] = 0;
		return(0);
	}
	str[0] = 0;
	return(-1);
}

#include <stdio.h>
int ip_resolve(struct ip_addr *addr, char *hostname)
{
	struct hostent *e;

	e = gethostbyname2(hostname, addr->af);
	if (!e) return(-1);

	if (addr->ipv == 4) memcpy(&addr->addr.v4.sin_addr,
		e->h_addr_list[0], 4);
	else if (addr->ipv == 6) memcpy(&addr->addr.v6.sin6_addr,
		e->h_addr_list[0], 16);
	else return(-1);
	return(0);
}

int ip_setport(struct ip_addr *addr, unsigned short port)
{
	if (addr->ipv == 6) addr->addr.v6.sin6_port = htons(port);
	else if (addr->ipv == 4) addr->addr.v4.sin_port = htons(port);
	else return(-1);
	return(0);
}

unsigned short ip_getport(struct ip_addr *addr)
{
	if (addr->ipv == 6) return(ntohs(addr->addr.v6.sin6_port));
	else return(ntohs(addr->addr.v4.sin_port));
}

