#ifndef __NET_IPV46_H
#define __NET_IPV46_H
#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>

#define IP_ADDRESS_STRING_SIZE	40

struct ip_addr {
	union {
		struct sockaddr gen;
		struct sockaddr_in v4;
		struct sockaddr_in6 v6;
	} addr;
	int ipv, pf, af, addrsize;
};

int ip_setipv(struct ip_addr *addr, int v);
int ip_consistent(struct ip_addr *addr);
int ip_sameaddr(struct ip_addr *a1, struct ip_addr *a2);
int ip_strtoaddr(struct ip_addr *addr, char *str);
int ip_resolve(struct ip_addr *addr, char *hostname);
int ip_addrtostr(char *str, struct ip_addr *addr);
int ip_setport(struct ip_addr *addr, unsigned short port);
unsigned short ip_getport(struct ip_addr *addr);

/*
	fd = socket(a.pf, SOCK_STREAM|DGRAM, 0);
	err = bind(fd, &a.addr.gen, a.addrsize);
	err = listen(fd, 256);
	ip_setipv(&c, 4|6);
	err = accept(fd, &c.addr.gen, &c.addrsize);
	err = !ip_consistent(&c);

	fd = connect(fd, &a.addr.gen, a.addrsize);
	
	nb = sendto(fd, buff, n, MSG_OOB|0, &a.addr.gen, a.addrsize);
		or equiv.: connect()/send()
	nb = recvfrom(fd, buff, n, MSG_OOB|PEEK|0, &a.addr.gen, &a.addrsize);
	err = !ip_consistent(&c);
 */

#endif

