#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include "timer.h"
#include "rw.h"

int bread(int fd, void *b, int n)
{
	int r;
	
	while (n>0) {
		r = read(fd, b, n);
		if ((r < 0) && (errno != EAGAIN) && (errno != EINTR)) {
			fprintf(stderr, "Read error: %s\n", strerror(errno));
			return(-1);
		}
		if (r == 0) {
			fprintf(stderr, "Read error: Unexpected EOF\n");
			return(-1);
		}
		if (r > 0) { b += r; n -= r; }
	}
	return(0);
}

int beread(int fd, void *b, int n)
{
	int r, g;
	
	g=0;
	while (g<n) {
		r = read(fd, b+g, n-g);
		if ((r < 0) && (errno != EAGAIN) && (errno != EINTR)) {
			fprintf(stderr, "Read error: %s\n", strerror(errno));
			return(-1);
		}
		if (r == 0){
			if (g == 0) return(1);
			fprintf(stderr, "Read error: Unexpected EOF %d\n", n);
			return(-1);
		}
		if (r > 0) g += r;
	}
	return(0);
}

int btread(int fd, void *b, int n, int timeout_ms)
{
	int r, i;
	
	i = 0;
	alarm_ms(timeout_ms, &i, 0);
	
	while (n>0) {
		if (i) {
			fprintf(stderr, "Read error: timeout elapsed\n");
			return(-1);
		}
		r = read(fd, b, n);
		if ((r < 0) && (errno != EAGAIN) && (errno != EINTR)) {
			alarm_ms(0,0,0);
			fprintf(stderr, "Read error: %s\n", strerror(errno));
			return(-1);
		}
		if (r == 0) {
			alarm_ms(0,0,0);
			fprintf(stderr, "Read error: Unexpected EOF\n");
			return(-1);
		}
		if (r > 0) { b += r; n -= r; }
	}
	alarm_ms(0,0,0);
	return(0);
}

int bwrite(int fd, void *b, int n)
{
	int r;
	
	while (n>0) {
		r = write(fd, b, n);
		if ((r < 0) && (errno != EAGAIN) && (errno != EINTR)) {
			fprintf(stderr, "Write error: %s\n", strerror(errno));
			return(-1);
		}
		if (r == 0) {
			fprintf(stderr, "Write error: EOF at write!\n");
			return(-1);
		}
		if (r > 0) { b += r; n -= r; }
	}
	return(0);
}


