#include <sys/time.h>
#include <signal.h>
#include <string.h>
#include <unistd.h>
#include "timer.h"

// ***********************************************
// timeval util
// ***********************************************
/*static void time_add(struct timeval *r,
	struct timeval *t1, struct timeval *t2)
{
	if (t1->tv_usec + t2->tv_usec >= 1000000) {
		r->tv_sec = t1->tv_sec + t2->tv_sec + 1;
		r->tv_usec = t1->tv_usec + t2->tv_usec - 1000000;
	} else {
		r->tv_sec = t1->tv_sec + t2->tv_sec;
		r->tv_usec = t1->tv_usec + t2->tv_usec;
	}
}*/

static void time_sub(struct timeval *r,
	struct timeval *t2, struct timeval *t1)
{
	if (t2->tv_usec < t1->tv_usec) {
		r->tv_sec = t2->tv_sec - t1->tv_sec - 1;
		r->tv_usec = 1000000 + t2->tv_usec - t1->tv_usec;
	} else {
		r->tv_sec = t2->tv_sec - t1->tv_sec;
		r->tv_usec = t2->tv_usec - t1->tv_usec;
	}
}

// ***********************************************
// funcs
// ***********************************************
static int inited = 0;
static struct timeval start_time;
static int *trigger = 0;

static void alarm_handler(int sig)
{
	if (trigger) (*trigger)++;
}

void timer_init()
{
	struct sigaction siga;
	
	siga.sa_handler = alarm_handler;
	memset(&siga.sa_mask, 0, sizeof(siga.sa_mask));
	siga.sa_flags = 0;
	sigaction(SIGALRM,  &siga, NULL);
	
	gettimeofday(&start_time, 0);
	
	inited = 1;
	trigger = 0;
}

unsigned int timer_ms()
{
	struct timeval v;
	
	if (!inited) timer_init();
	gettimeofday(&v, 0);
	time_sub(&v, &v, &start_time);
	return((v.tv_sec * 1000) + (v.tv_usec / 1000));
}

void sleep_ms(unsigned int n)
{
	int lt;
	struct itimerval v;
	
	if (!inited) timer_init();
	lt = 0;
	trigger = &lt;
	v.it_interval.tv_sec = 0;
	v.it_interval.tv_usec = 0;
	v.it_value.tv_sec = n / 1000;
	v.it_value.tv_usec = (n % 1000) * 1000;
	setitimer(ITIMER_REAL, &v, 0);
	while (lt == 0) {
		pause();
	}
}

void alarm_ms(unsigned int n, int *toinc, int periodic)
{
	struct itimerval v;
	
	if (!inited) timer_init();
	if (n) {
		trigger = toinc;
		v.it_value.tv_sec = n / 1000;
		v.it_value.tv_usec = (n % 1000) * 1000;
	} else {
		trigger = 0;
		v.it_value.tv_sec = 0;
		v.it_value.tv_usec = 0;
	}
	if (periodic) {
		v.it_interval.tv_sec = v.it_value.tv_sec;
		v.it_interval.tv_usec = v.it_value.tv_usec;
	} else {
		v.it_interval.tv_sec = 0;
		v.it_interval.tv_usec = 0;
	}
	setitimer(ITIMER_REAL, &v, 0);
}

