#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <sys/mman.h>
#include <fcntl.h>
#include <string.h>
#include <errno.h>
#include <linux/videodev.h>
#include "video_capture.h"

#define PE(s...)	fprintf(stderr, s)

struct video_input_info video_map =
	{ -1, 0, 0, 0, 0, 0, 0, 0, 0 };

void capture_close()
{
	if (video_map.fd >= 0) {
		munmap(video_map.data, video_map.size);
		close(video_map.fd);
	}
	// XXX
	if ((video_map.fd < 0) && (video_map.data)) {
		PE("v4l: WARNING: Used emulated video device (freed)\n");
		free(video_map.data);
	}
}

#define VCN(c)	{ VID_TYPE_ ## c, #c }
struct {
	int val;
	char *name;
} vidin_capsnames[] = {
	VCN(CAPTURE), VCN(TUNER), VCN(TELETEXT), VCN(OVERLAY), VCN(CHROMAKEY),
	VCN(CLIPPING), VCN(FRAMERAM), VCN(SCALES), VCN(MONOCHROME),
	VCN(SUBCAPTURE), VCN(MPEG_DECODER), VCN(MPEG_ENCODER),
	VCN(MJPEG_DECODER), VCN(MJPEG_ENCODER), {0,"end"}
};
static char *vidin_palname[17] = {
	"Hugh?", "greyscale", "High 240 cube (BT848)", "RGB 5:6:5",
	"BGR-24", "BGRA-32", "RGB 5:5:5", "YUV422", "YUYV", "UYVY",
	"YUV420", "YUV411", "Raw (BT848)", "planar YUV422",
	"planar YUV411", "planar YUV420", "planar YUV410" };

static int capture_sub_init()
{
	char *devicename;
	struct video_capability cap;
	struct video_picture pict;
	int t;

	devicename = "/dev/video0";
	PE("v4l: %s: ", devicename);
	video_map.fd = open(devicename, O_RDONLY);
	if (video_map.fd < 0) {
		PE("Can't open device: %s\n", strerror(errno));
		return(-1);
	}
	if (ioctl(video_map.fd, VIDIOCGCAP, &cap)) {
		PE("Can't get capabilites: %s\n", strerror(errno));
		close(video_map.fd); return(-1);
	}
	if (ioctl(video_map.fd, VIDIOCGPICT, &pict)) {
		PE("Can't get picture size: %s\n", strerror(errno));
		close(video_map.fd); return(-1);
	}
	PE("\"%s\",", cap.name);
	t=0;
	while (vidin_capsnames[t].val != 0) {
		if (cap.type & vidin_capsnames[t].val)
			PE(" %s", vidin_capsnames[t].name);
		t++;
	}
	video_map.fmt_id = pict.palette;
	video_map.depth = pict.depth;
	video_map.w = cap.maxwidth;
	video_map.h = cap.maxheight;
	video_map.nbpix = video_map.w * video_map.h;
	video_map.linesize = video_map.w * (video_map.depth>>3);
	video_map.size = video_map.linesize * video_map.h;
	
	if ((cap.minwidth==cap.maxwidth) && (cap.minheight==cap.maxheight))
		PE("\n\t%dx%d, ", video_map.w, video_map.h);
	else PE("\n%dx%d -> %dx%d, guessing size is %dx%d !!!\n\tFormat: ",
		cap.minwidth, cap.minheight, cap.maxwidth, cap.maxheight,
		video_map.w, video_map.h);
	if (pict.palette < (sizeof(vidin_palname)>>2))
		PE("%dbpp %s\n", pict.depth, vidin_palname[pict.palette]);
	else	PE("%dbpp, palette %d\n", pict.depth, pict.palette);

	
	video_map.data = mmap(NULL, video_map.size, PROT_READ, MAP_SHARED,
		video_map.fd, 0);
	if (video_map.data == MAP_FAILED) {
		PE("Can't mmap video input: %s\n", strerror(errno));
		close(video_map.fd); return(-1);
	}
	return(0);
}

int capture_init()
{
	if (!capture_sub_init()) return(0);

	PE("v4l: WARNING: video device simulated\n");
	video_map.fmt_id = VIDEO_PALETTE_YUV422;
	video_map.depth = 16;
	video_map.w = 720;
	video_map.h = 240;
	video_map.nbpix = video_map.w * video_map.h;
	video_map.linesize = video_map.w * (video_map.depth>>3);
	video_map.size = video_map.linesize * video_map.h;
	video_map.data = malloc(video_map.size);
	if (!video_map.data) {
		PE("v4l (simulated): memory lack!\n");
		return(-1);
	}
	return(0);
}
