/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dist;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.dist.Count;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.DistributionFactory;
import org.biojava.bio.dist.OrderNDistribution;
import org.biojava.bio.dist.SimpleDistributionTrainerContext;
import org.biojava.bio.dist.UniformDistribution;
import org.biojava.bio.dist.XMLDistributionReader;
import org.biojava.bio.dist.XMLDistributionWriter;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.impl.SimpleSequence;
import org.biojava.bio.symbol.Alignment;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetIndex;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.BasisSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.LocationTools;
import org.biojava.bio.symbol.PointLocation;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.bio.symbol.SymbolListViews;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.NestedError;
import org.biojava.utils.NestedException;
import org.xml.sax.SAXException;

public final class DistributionTools {
    private DistributionTools() {
    }

    public static void writeToXML(Distribution d, OutputStream os) throws IOException {
        new XMLDistributionWriter().writeDistribution(d, os);
    }

    public static Distribution readFromXML(InputStream is) throws IOException, SAXException {
        XMLDistributionReader writer = new XMLDistributionReader();
        return writer.parseXML(is);
    }

    public static void randomizeDistribution(Distribution d) throws ChangeVetoException {
        Random rand = new Random();
        FiniteAlphabet a = (FiniteAlphabet)d.getAlphabet();
        AlphabetIndex ind = AlphabetManager.getAlphabetIndex(a);
        SimpleDistributionTrainerContext dtc = new SimpleDistributionTrainerContext();
        dtc.registerDistribution(d);
        int i = 0;
        while (i < a.size()) {
            try {
                dtc.addCount(d, ind.symbolForIndex(i), rand.nextDouble());
            }
            catch (IllegalSymbolException ex) {
                throw new BioError(ex, "Alphabet has Illegal Symbols!!");
            }
            ++i;
        }
        dtc.train();
    }

    public static Distribution countToDistribution(Count c) {
        FiniteAlphabet a = (FiniteAlphabet)c.getAlphabet();
        Distribution d = null;
        try {
            d = DistributionFactory.DEFAULT.createDistribution(a);
            AlphabetIndex index = AlphabetManager.getAlphabetIndex(a);
            SimpleDistributionTrainerContext dtc = new SimpleDistributionTrainerContext();
            dtc.registerDistribution(d);
            int i = 0;
            while (i < a.size()) {
                dtc.addCount(d, index.symbolForIndex(i), c.getCount((AtomicSymbol)index.symbolForIndex(i)));
                ++i;
            }
            dtc.train();
        }
        catch (NestedException ne) {
            throw new BioError(ne, "Assertion Error: Cannot convert Count to Distribution");
        }
        return d;
    }

    public static final boolean areEmissionSpectraEqual(Distribution a, Distribution b) throws BioException {
        if (!(a.getAlphabet() instanceof FiniteAlphabet) || !(b.getAlphabet() instanceof FiniteAlphabet)) {
            throw new IllegalAlphabetException("Cannot compare emission spectra over infinite alphabet");
        }
        if (!a.getAlphabet().equals(b.getAlphabet())) {
            return false;
        }
        Iterator i = ((FiniteAlphabet)a.getAlphabet()).iterator();
        while (i.hasNext()) {
            Symbol s = (Symbol)i.next();
            if (a.getWeight(s) == b.getWeight(s)) continue;
            return false;
        }
        return true;
    }

    public static final boolean areEmissionSpectraEqual(Distribution[] a, Distribution[] b) throws BioException {
        if (a.length != b.length) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            if (!DistributionTools.areEmissionSpectraEqual(a[i], b[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final HashMap KLDistance(Distribution observed, Distribution expected, double logBase) {
        Iterator alpha = ((FiniteAlphabet)observed.getAlphabet()).iterator();
        HashMap<Symbol, Double> kldist = new HashMap<Symbol, Double>(((FiniteAlphabet)observed.getAlphabet()).size());
        while (alpha.hasNext()) {
            Symbol s = (Symbol)alpha.next();
            try {
                double obs = observed.getWeight(s);
                double exp = expected.getWeight(s);
                if (obs == 0.0) {
                    kldist.put(s, new Double(0.0));
                    continue;
                }
                double entropy = obs * Math.log(obs / exp) / Math.log(logBase);
                kldist.put(s, new Double(entropy));
            }
            catch (IllegalSymbolException ise) {
                ise.printStackTrace(System.err);
            }
        }
        return kldist;
    }

    public static final HashMap shannonEntropy(Distribution observed, double logBase) {
        Iterator alpha = ((FiniteAlphabet)observed.getAlphabet()).iterator();
        HashMap<Symbol, Double> entropy = new HashMap<Symbol, Double>(((FiniteAlphabet)observed.getAlphabet()).size());
        while (alpha.hasNext()) {
            Symbol s = (Symbol)alpha.next();
            try {
                double obs = observed.getWeight(s);
                if (obs == 0.0) continue;
                double e = -Math.log(obs) / Math.log(logBase);
                entropy.put(s, new Double(e));
            }
            catch (IllegalSymbolException ise) {
                ise.printStackTrace(System.err);
            }
        }
        return entropy;
    }

    public static double totalEntropy(Distribution observed) {
        HashMap ent = DistributionTools.shannonEntropy(observed, 2.0);
        double totalEntropy = 0.0;
        try {
            Iterator i = ent.keySet().iterator();
            while (i.hasNext()) {
                Symbol sym = (Symbol)i.next();
                totalEntropy += observed.getWeight(sym) * (Double)ent.get(sym);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return totalEntropy;
    }

    public static final double bitsOfInformation(Distribution observed) {
        double totalEntropy = DistributionTools.totalEntropy(observed);
        int size = ((FiniteAlphabet)observed.getAlphabet()).size();
        return Math.log(size) / Math.log(2.0) - totalEntropy;
    }

    public static Distribution[] distOverAlignment(Alignment a) throws IllegalAlphabetException {
        return DistributionTools.distOverAlignment(a, false, 0.0);
    }

    public static final Distribution jointDistOverAlignment(Alignment a, boolean countGaps, double nullWeight, int[] cols) throws IllegalAlphabetException {
        List seqs = a.getLabels();
        FiniteAlphabet alpha = (FiniteAlphabet)a.symbolListForLabel(seqs.get(0)).getAlphabet();
        int i = 1;
        while (i < seqs.size()) {
            FiniteAlphabet test = (FiniteAlphabet)a.symbolListForLabel(seqs.get(i)).getAlphabet();
            if (test != alpha) {
                throw new IllegalAlphabetException("Cannot Calculate distOverAlignment() for alignments withmixed alphabets");
            }
            ++i;
        }
        ArrayList<FiniteAlphabet> a_list = new ArrayList<FiniteAlphabet>();
        int i2 = 0;
        while (i2 < cols.length) {
            a_list.add(alpha);
            ++i2;
        }
        SimpleDistributionTrainerContext dtc = new SimpleDistributionTrainerContext();
        Distribution dist = DistributionFactory.DEFAULT.createDistribution(AlphabetManager.getCrossProductAlphabet(a_list));
        dtc.setNullModelWeight(nullWeight);
        try {
            dtc.registerDistribution(dist);
            Location loc = new PointLocation(cols[0]);
            int j = 0;
            while (j < cols.length) {
                PointLocation lj = new PointLocation(cols[j]);
                loc = LocationTools.union(loc, lj);
                ++j;
            }
            Alignment subalign = a.subAlignment(new HashSet(seqs), loc);
            Iterator s_it = subalign.symbolListIterator();
            while (s_it.hasNext()) {
                SymbolList syml = (SymbolList)s_it.next();
                Symbol s = SymbolListViews.orderNSymbolList(syml, syml.length()).symbolAt(1);
                if (!countGaps && syml.toList().contains(a.getAlphabet().getGapSymbol())) continue;
                dtc.addCount(dist, s, 1.0);
            }
            dtc.train();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return dist;
    }

    public static final Distribution[] distOverAlignment(Alignment a, boolean countGaps, double nullWeight) throws IllegalAlphabetException {
        List seqs = a.getLabels();
        FiniteAlphabet alpha = (FiniteAlphabet)a.symbolListForLabel(seqs.get(0)).getAlphabet();
        int i = 1;
        while (i < seqs.size()) {
            FiniteAlphabet test = (FiniteAlphabet)a.symbolListForLabel(seqs.get(i)).getAlphabet();
            if (test != alpha) {
                throw new IllegalAlphabetException("Cannot Calculate distOverAlignment() for alignments withmixed alphabets");
            }
            ++i;
        }
        Distribution[] pos = new Distribution[a.length()];
        SimpleDistributionTrainerContext dtc = new SimpleDistributionTrainerContext();
        dtc.setNullModelWeight(nullWeight);
        try {
            int i2 = 0;
            while (i2 < a.length()) {
                pos[i2] = DistributionFactory.DEFAULT.createDistribution(alpha);
                dtc.registerDistribution(pos[i2]);
                Iterator j = seqs.iterator();
                while (j.hasNext()) {
                    Object seqLabel = j.next();
                    Symbol s = a.symbolAt(seqLabel, i2 + 1);
                    if (!countGaps && s.equals(a.getAlphabet().getGapSymbol())) continue;
                    dtc.addCount(pos[i2], s, 1.0);
                }
                ++i2;
            }
            dtc.train();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return pos;
    }

    public static final Distribution[] distOverAlignment(Alignment a, boolean countGaps) throws IllegalAlphabetException {
        return DistributionTools.distOverAlignment(a, countGaps, 0.0);
    }

    public static final Distribution average(Distribution[] dists) {
        Alphabet alpha = dists[0].getAlphabet();
        int i = 1;
        while (i < dists.length) {
            if (!dists[i].getAlphabet().equals(alpha)) {
                throw new IllegalArgumentException("All alphabets must be the same");
            }
            ++i;
        }
        try {
            Distribution average = DistributionFactory.DEFAULT.createDistribution(alpha);
            SimpleDistributionTrainerContext dtc = new SimpleDistributionTrainerContext();
            dtc.registerDistribution(average);
            int i2 = 0;
            while (i2 < dists.length) {
                Iterator iter = ((FiniteAlphabet)dists[i2].getAlphabet()).iterator();
                while (iter.hasNext()) {
                    Symbol sym = (Symbol)iter.next();
                    dtc.addCount(average, sym, dists[i2].getWeight(sym));
                }
                ++i2;
            }
            dtc.train();
            return average;
        }
        catch (IllegalAlphabetException iae) {
            throw new NestedError(iae, "Distribution contains an illegal alphabet");
        }
        catch (IllegalSymbolException ise) {
            throw new NestedError(ise, "Distribution contains an illegal symbol");
        }
        catch (ChangeVetoException cve) {
            throw new NestedError(cve, "The Distribution has become locked");
        }
    }

    public static final Sequence generateSequence(String name, Distribution d, int length) {
        if (d instanceof OrderNDistribution) {
            return DistributionTools.generateOrderNSequence(name, (OrderNDistribution)d, length);
        }
        SimpleSymbolList sl = null;
        ArrayList<Symbol> l = new ArrayList<Symbol>(length);
        int i = 0;
        while (i < length) {
            l.add(d.sampleSymbol());
            ++i;
        }
        try {
            sl = new SimpleSymbolList(d.getAlphabet(), l);
        }
        catch (IllegalSymbolException ex) {
            throw new BioError("Distribution emitting Symbols not from its Alphabet?");
        }
        return new SimpleSequence(sl, name, name, Annotation.EMPTY_ANNOTATION);
    }

    protected static final Sequence generateOrderNSequence(String name, OrderNDistribution d, int length) {
        SimpleSymbolList sl = null;
        ArrayList<Symbol> l = new ArrayList<Symbol>(length);
        FiniteAlphabet cond = (FiniteAlphabet)d.getConditioningAlphabet();
        UniformDistribution uni = new UniformDistribution(cond);
        BasisSymbol seed = (BasisSymbol)uni.sampleSymbol();
        LinkedList<Symbol> ll = new LinkedList<Symbol>(seed.getSymbols());
        try {
            int i = 0;
            while (i < 1000 + length) {
                Symbol sym = d.getDistribution(seed).sampleSymbol();
                if (i >= 1000) {
                    l.add(sym);
                }
                ll.addLast(sym);
                ll.removeFirst();
                seed = (BasisSymbol)cond.getSymbol(ll);
                ++i;
            }
            sl = new SimpleSymbolList(d.getConditionedAlphabet(), l);
        }
        catch (IllegalSymbolException ex) {
            throw new BioError("Distribution emitting Symbols not from its Alphabet?");
        }
        return new SimpleSequence(sl, name, name, Annotation.EMPTY_ANNOTATION);
    }
}

