/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dist;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.biojava.bio.BioError;
import org.biojava.bio.dist.AbstractDistribution;
import org.biojava.bio.dist.Count;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.DistributionTrainer;
import org.biojava.bio.dist.DistributionTrainerContext;
import org.biojava.bio.dist.IndexedCount;
import org.biojava.bio.dist.UniformDistribution;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetIndex;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ChangeAdapter;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeVetoException;

public class SimpleDistribution
extends AbstractDistribution
implements Serializable {
    private transient AlphabetIndex indexer;
    private transient double[] weights = null;
    private Distribution nullModel;
    private FiniteAlphabet alpha;
    private static final long serialVersionUID = 899744356L;

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.indexer = AlphabetManager.getAlphabetIndex(this.alpha);
        this.indexer.addChangeListener(new ChangeAdapter(){

            public void preChange(ChangeEvent ce) throws ChangeVetoException {
                if (SimpleDistribution.this.hasWeights()) {
                    throw new ChangeVetoException(ce, "Can't allow the index to change as we have probabilities.");
                }
            }
        }, AlphabetIndex.INDEX);
        this.weights = new double[this.alpha.size()];
        int i = 0;
        while (i < this.weights.length) {
            String s = this.indexer.symbolForIndex(i).getName();
            this.weights[i] = this.symbolIndices.get(s) != null ? (Double)this.symbolIndices.get(s) : 0.0;
            ++i;
        }
        this.symbolIndices = null;
    }

    public Alphabet getAlphabet() {
        return this.indexer.getAlphabet();
    }

    public Distribution getNullModel() {
        return this.nullModel;
    }

    protected void setNullModelImpl(Distribution nullModel) throws IllegalAlphabetException, ChangeVetoException {
        this.nullModel = nullModel;
    }

    protected boolean hasWeights() {
        return this.weights != null;
    }

    protected double[] getWeights() {
        if (this.weights == null) {
            this.weights = new double[((FiniteAlphabet)this.getAlphabet()).size()];
            int i = 0;
            while (i < this.weights.length) {
                this.weights[i] = Double.NaN;
                ++i;
            }
        }
        return this.weights;
    }

    public double getWeightImpl(AtomicSymbol s) throws IllegalSymbolException {
        if (!this.hasWeights()) {
            return Double.NaN;
        }
        int index = this.indexer.indexForSymbol(s);
        return this.weights[index];
    }

    protected void setWeightImpl(AtomicSymbol s, double w) throws IllegalSymbolException, ChangeVetoException {
        double[] weights = this.getWeights();
        if (w < 0.0) {
            throw new IllegalArgumentException("Can't set weight to negative score: " + s.getName() + " -> " + w);
        }
        weights[this.indexer.indexForSymbol((Symbol)s)] = w;
    }

    public SimpleDistribution(FiniteAlphabet alphabet) {
        this.alpha = alphabet;
        this.indexer = AlphabetManager.getAlphabetIndex(alphabet);
        this.indexer.addChangeListener(new ChangeAdapter(){

            public void preChange(ChangeEvent ce) throws ChangeVetoException {
                if (SimpleDistribution.this.hasWeights()) {
                    throw new ChangeVetoException(ce, "Can't allow the index to change as we have probabilities.");
                }
            }
        }, AlphabetIndex.INDEX);
        try {
            this.setNullModel(new UniformDistribution(alphabet));
        }
        catch (Exception e) {
            throw new BioError(e, "This should never fail. Something is screwed!");
        }
    }

    public void registerWithTrainer(DistributionTrainerContext dtc) {
        dtc.registerTrainer(this, new Trainer());
    }

    protected class Trainer
    implements DistributionTrainer {
        private final Count counts;

        public Trainer() {
            this.counts = new IndexedCount(SimpleDistribution.this.indexer);
        }

        public void addCount(DistributionTrainerContext dtc, AtomicSymbol sym, double times) throws IllegalSymbolException {
            try {
                this.counts.increaseCount(sym, times);
            }
            catch (ChangeVetoException cve) {
                throw new BioError(cve, "Assertion Failure: Change to Count object vetoed");
            }
        }

        public double getCount(DistributionTrainerContext dtc, AtomicSymbol sym) throws IllegalSymbolException {
            return this.counts.getCount(sym);
        }

        public void clearCounts(DistributionTrainerContext dtc) {
            try {
                int size = ((FiniteAlphabet)this.counts.getAlphabet()).size();
                int i = 0;
                while (i < size) {
                    this.counts.zeroCounts();
                    ++i;
                }
            }
            catch (ChangeVetoException cve) {
                throw new BioError(cve, "Assertion Failure: Change to Count object vetoed");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void train(DistributionTrainerContext dtc, double weight) throws ChangeVetoException {
            if (!SimpleDistribution.this.hasListeners()) {
                this.trainImpl(dtc, weight);
            } else {
                ChangeSupport changeSupport;
                ChangeSupport changeSupport2 = changeSupport = SimpleDistribution.this.getChangeSupport(Distribution.WEIGHTS);
                synchronized (changeSupport2) {
                    ChangeEvent ce = new ChangeEvent(SimpleDistribution.this, Distribution.WEIGHTS);
                    changeSupport.firePreChangeEvent(ce);
                    this.trainImpl(dtc, weight);
                    changeSupport.firePostChangeEvent(ce);
                }
            }
        }

        protected void trainImpl(DistributionTrainerContext dtc, double weight) {
            try {
                Distribution nullModel = SimpleDistribution.this.getNullModel();
                double[] weights = SimpleDistribution.this.getWeights();
                double[] total = new double[weights.length];
                double sum = 0.0;
                int i = 0;
                while (i < total.length) {
                    AtomicSymbol s = (AtomicSymbol)SimpleDistribution.this.indexer.symbolForIndex(i);
                    total[i] = this.getCount(dtc, s) + nullModel.getWeight(s) * weight;
                    sum += total[i];
                    ++i;
                }
                double sum_inv = 1.0 / sum;
                int i2 = 0;
                while (i2 < total.length) {
                    weights[i2] = total[i2] * sum_inv;
                    ++i2;
                }
            }
            catch (IllegalSymbolException ise) {
                throw new BioError(ise, "Assertion Failure: Should be impossible to mess up the symbols.");
            }
        }
    }
}

