/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dp;

import org.biojava.bio.BioException;
import org.biojava.bio.dp.DP;
import org.biojava.bio.dp.IllegalTransitionException;
import org.biojava.bio.dp.ModelTrainer;
import org.biojava.bio.dp.SimpleModelTrainer;
import org.biojava.bio.dp.StoppingCriteria;
import org.biojava.bio.dp.TrainingAlgorithm;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SymbolList;

public abstract class AbstractTrainer
implements TrainingAlgorithm {
    private DP dp;
    private double lastScore = Double.POSITIVE_INFINITY;
    private double currentScore = Double.POSITIVE_INFINITY;
    private int cycle;

    public double getLastScore() {
        return this.lastScore;
    }

    public double getCurrentScore() {
        return this.currentScore;
    }

    public int getCycle() {
        return this.cycle;
    }

    public DP getDP() {
        return this.dp;
    }

    protected abstract double singleSequenceIteration(ModelTrainer var1, SymbolList var2) throws IllegalSymbolException, IllegalTransitionException, IllegalAlphabetException;

    public void train(SequenceDB db, double nullModelWeight, StoppingCriteria stopper) throws IllegalSymbolException, BioException {
        try {
            SimpleModelTrainer trainer = new SimpleModelTrainer();
            trainer.setNullModelWeight(nullModelWeight);
            trainer.registerModel(this.dp.getModel());
            do {
                ++this.cycle;
                this.lastScore = this.currentScore;
                this.currentScore = 0.0;
                SequenceIterator si = db.sequenceIterator();
                while (si.hasNext()) {
                    Sequence seq = si.nextSequence();
                    this.currentScore += this.singleSequenceIteration(trainer, seq);
                }
                trainer.train();
                trainer.clearCounts();
            } while (!stopper.isTrainingComplete(this));
        }
        catch (Exception e) {
            throw new BioException(e, "Unable to train");
        }
    }

    public AbstractTrainer(DP dp) {
        this.dp = dp;
    }

    protected AbstractTrainer() {
    }
}

