/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui;

import java.awt.Color;
import java.awt.Paint;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.biojava.bio.BioError;
import org.biojava.bio.gui.SymbolStyle;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;

public class SimpleSymbolStyle
implements SymbolStyle {
    private final Map outlinePaint = new HashMap();
    private final Map fillPaint = new HashMap();
    private final FiniteAlphabet alphabet;
    private static Map standardFillPaints = new HashMap();
    private static Map standardOutlinePaints = new HashMap();

    public Alphabet getAlphabet() {
        return this.alphabet;
    }

    public SimpleSymbolStyle(FiniteAlphabet alphabet) {
        this.alphabet = alphabet;
        Map outline = SimpleSymbolStyle.getStandardOutlinePaints(alphabet);
        Map fill = SimpleSymbolStyle.getStandardFillPaints(alphabet);
        try {
            if (fill == null || outline == null) {
                Iterator i = alphabet.iterator();
                while (i.hasNext()) {
                    Symbol s = (Symbol)i.next();
                    if (outline == null) {
                        this.setOutlinePaint(s, Color.black);
                    } else {
                        this.setOutlinePaint(s, (Paint)outline.get(s));
                    }
                    if (fill == null) {
                        this.setFillPaint(s, Color.gray);
                        continue;
                    }
                    this.setOutlinePaint(s, (Paint)fill.get(s));
                }
            }
        }
        catch (IllegalSymbolException ire) {
            throw new BioError(ire, "Symbol dissapeared from my alphabet");
        }
    }

    public Paint outlinePaint(Symbol s) throws IllegalSymbolException {
        this.getAlphabet().validate(s);
        return (Paint)this.outlinePaint.get(s);
    }

    public Paint fillPaint(Symbol s) throws IllegalSymbolException {
        this.getAlphabet().validate(s);
        return (Paint)this.fillPaint.get(s);
    }

    public void setOutlinePaint(Symbol s, Paint paint) throws IllegalSymbolException {
        this.getAlphabet().validate(s);
        this.outlinePaint.put(s, paint);
    }

    public void setFillPaint(Symbol s, Paint paint) throws IllegalSymbolException {
        this.getAlphabet().validate(s);
        this.fillPaint.put(s, paint);
    }

    public static Map getStandardFillPaints(Alphabet alpha) {
        return (Map)standardFillPaints.get(alpha);
    }

    public static Map getStandardOutlinePaints(Alphabet alpha) {
        return (Map)standardOutlinePaints.get(alpha);
    }

    static {
        HashMap<AtomicSymbol, Color> dnaFill = new HashMap<AtomicSymbol, Color>();
        dnaFill.put(DNATools.t(), Color.red);
        dnaFill.put(DNATools.g(), Color.blue);
        dnaFill.put(DNATools.c(), Color.yellow);
        dnaFill.put(DNATools.a(), Color.green);
        standardFillPaints.put(DNATools.getDNA(), dnaFill);
        HashMap<AtomicSymbol, Color> dnaOutline = new HashMap<AtomicSymbol, Color>();
        dnaOutline.put(DNATools.t(), Color.black);
        dnaOutline.put(DNATools.a(), Color.black);
        dnaOutline.put(DNATools.g(), Color.black);
        dnaOutline.put(DNATools.c(), Color.black);
        standardOutlinePaints.put(DNATools.getDNA(), dnaOutline);
    }
}

