/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.blast2html;

import org.biojava.bio.program.blast2html.AlignmentStyler;
import org.biojava.bio.program.blast2html.ColourCommand;

public class AlignmentMarker {
    private StringBuffer[] markedUp = new StringBuffer[3];
    private String[] oCurrentStyle;
    private String[] oNewStyle;
    private ColourCommand oColourCommand;
    private AlignmentStyler oStyler;

    public AlignmentMarker(ColourCommand poColourCommand, AlignmentStyler poStyler) {
        this.markedUp[0] = new StringBuffer(150);
        this.markedUp[1] = new StringBuffer(150);
        this.markedUp[2] = new StringBuffer(150);
        this.oCurrentStyle = new String[3];
        this.oCurrentStyle[0] = null;
        this.oCurrentStyle[1] = null;
        this.oCurrentStyle[2] = null;
        this.oNewStyle = new String[3];
        this.oColourCommand = poColourCommand;
        this.oStyler = poStyler;
    }

    String getAlignmentStyles() {
        return this.oStyler.getAlignmentStyles();
    }

    void alignment2HTML(String[] poAlignment) {
        if (poAlignment == null || poAlignment.length != 3 || poAlignment[0].length() != poAlignment[1].length() || poAlignment[0].length() != poAlignment[2].length()) {
            System.err.println("-->" + poAlignment[0] + "<--");
            System.err.println("-->" + poAlignment[1] + "<--");
            System.err.println("-->" + poAlignment[2] + "<--");
            throw new IllegalArgumentException("Only accept array of three strings, all of same length");
        }
        if (this.oStyler == null) {
            return;
        }
        this.markedUp[0].setLength(0);
        this.markedUp[1].setLength(0);
        this.markedUp[2].setLength(0);
        this.oCurrentStyle[0] = null;
        this.oCurrentStyle[1] = null;
        this.oCurrentStyle[2] = null;
        int i = 0;
        int n = poAlignment[0].length();
        while (i < n) {
            String oSecond;
            String oFirst = String.valueOf(poAlignment[0].charAt(i));
            if (this.oColourCommand.isColoured(oFirst, oSecond = String.valueOf(poAlignment[1].charAt(i)))) {
                this.oStyler.getStyle(oFirst, oSecond, this.oNewStyle);
            } else {
                this.oNewStyle[0] = null;
                this.oNewStyle[1] = null;
                this.oNewStyle[2] = null;
            }
            this.applyStyles(this.oCurrentStyle, this.oNewStyle, this.markedUp);
            this.markedUp[0].append(oFirst);
            this.markedUp[1].append(oSecond);
            this.markedUp[2].append(poAlignment[2].charAt(i));
            System.arraycopy(this.oNewStyle, 0, this.oCurrentStyle, 0, this.oNewStyle.length);
            ++i;
        }
        this.flushStyles(this.oCurrentStyle, this.markedUp);
        poAlignment[0] = this.markedUp[0].substring(0);
        poAlignment[1] = this.markedUp[1].substring(0);
        poAlignment[2] = this.markedUp[2].substring(0);
    }

    private void applyStyles(String[] poCurrentStyle, String[] poNewStyle, StringBuffer[] poMarkedUp) {
        int i = 0;
        int n = poCurrentStyle.length;
        while (i < n) {
            this.applyStyle(poCurrentStyle[i], poNewStyle[i], poMarkedUp[i]);
            ++i;
        }
    }

    private void applyStyle(String poCurrentStyle, String poNewStyle, StringBuffer poOutput) {
        if (poNewStyle == null) {
            if (poCurrentStyle != null) {
                poOutput.append("</FONT>");
            }
        } else if (!poNewStyle.equals(poCurrentStyle)) {
            if (poCurrentStyle != null) {
                poOutput.append("</FONT>");
            }
            poOutput.append("<FONT CLASS=" + poNewStyle + ">");
        }
    }

    private void flushStyles(String[] poCurrentStyle, StringBuffer[] poMarkedUp) {
        int i = 0;
        int n = poCurrentStyle.length;
        while (i < n) {
            if (poCurrentStyle[i] != null) {
                poMarkedUp[i].append("</FONT>");
            }
            ++i;
        }
    }
}

