/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.blast2html;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import org.biojava.bio.program.blast2html.SimpleAlignmentStyler;

class BlastMatrixAlignmentStyler
extends SimpleAlignmentStyler {
    private String[] aoChars = null;
    private int iNumberOfChars = 0;
    private int[][] aoScore = null;

    public BlastMatrixAlignmentStyler() {
        super(SimpleAlignmentStyler.SHOW_ALL);
        super.readColourMap();
        String oPropFilename = System.getProperty("blastMatrix");
        if (oPropFilename == null) {
            System.err.println("No blast matrix specified with -DblastMatrix=<filename>");
        } else {
            try {
                this.readBlastMatrix(oPropFilename);
                this.createAlignmentColours();
            }
            catch (IOException e) {
                System.err.println(e);
                e.printStackTrace();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void readBlastMatrix(String poFileName) throws IOException {
        BufferedReader in = null;
        try {
            File oFile = new File(poFileName);
            FileReader oFileReader = new FileReader(oFile);
            in = new BufferedReader(oFileReader);
            StringBuffer sb = new StringBuffer();
            String oLine = in.readLine();
            boolean isFirst = true;
            int iCurrent = 0;
            while (true) {
                block17: {
                    int i;
                    StringTokenizer st;
                    if (oLine == null) {
                        in.close();
                        break;
                    }
                    if (oLine.startsWith("#") || oLine.trim().equals("")) {
                        oLine = in.readLine();
                        continue;
                    }
                    if (isFirst) {
                        st = new StringTokenizer(oLine);
                        this.iNumberOfChars = st.countTokens();
                        this.aoChars = new String[this.iNumberOfChars];
                        this.aoScore = new int[this.iNumberOfChars][this.iNumberOfChars];
                        i = 0;
                        while (true) {
                            if (!st.hasMoreTokens()) {
                                isFirst = false;
                                break block17;
                            }
                            this.aoChars[i] = st.nextToken();
                            ++i;
                        }
                    }
                    st = new StringTokenizer(oLine);
                    i = 0;
                    st.nextToken();
                    while (true) {
                        if (!st.hasMoreTokens()) {
                            ++iCurrent;
                            break;
                        }
                        this.aoScore[iCurrent][i] = Integer.parseInt(st.nextToken());
                        ++i;
                    }
                }
                oLine = in.readLine();
            }
            Object var12_12 = null;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            try {
                in.close();
                throw throwable;
            }
            catch (Exception x) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception x) {}
        in.close();
        return;
    }

    private void createAlignmentColours() {
        int iMatchMin = 0;
        int iMatchMax = 0;
        int i = 0;
        while (i < this.iNumberOfChars) {
            int j = 0;
            while (j < this.iNumberOfChars) {
                int iCurrent = this.aoScore[i][j];
                if (iCurrent < iMatchMin) {
                    iMatchMin = iCurrent;
                } else if (iCurrent > iMatchMax) {
                    iMatchMax = iCurrent;
                }
                ++j;
            }
            ++i;
        }
        int iRange = iMatchMax - iMatchMin;
        int i2 = 0;
        while (i2 < this.iNumberOfChars) {
            int j = 0;
            while (j < this.iNumberOfChars) {
                int iCurrent = this.aoScore[i2][j];
                double dNorm = (double)(iCurrent - iMatchMin) / (double)iRange;
                float var = (float)(((dNorm *= 0.33) - 0.165) * (dNorm - 0.165));
                Color oColor = Color.getHSBColor(1.0f - (float)dNorm, 0.0f + var * 20.0f, 1.0f);
                String oColourString = this.toHex(oColor);
                String oColourClass = this.getColourClass(oColourString);
                this.oColourMap.put("!".concat(this.aoChars[i2].concat(this.aoChars[j])), oColourClass);
                ++j;
            }
            ++i2;
        }
    }

    private String toHex(Color poColor) {
        StringBuffer sb = new StringBuffer(7);
        sb.append(this.padHex(Integer.toHexString(poColor.getRed())));
        sb.append(this.padHex(Integer.toHexString(poColor.getGreen())));
        sb.append(this.padHex(Integer.toHexString(poColor.getBlue())));
        return sb.substring(0);
    }

    private String padHex(String poHex) {
        if (poHex.length() == 1) {
            return "0".concat(poHex);
        }
        return poHex;
    }

    public void getStyle(String poFirst, String poSecond, String[] poStyleHolder) {
        poStyleHolder[0] = (String)this.oColourMap.get(poFirst);
        poStyleHolder[1] = (String)this.oColourMap.get(poSecond);
        poStyleHolder[2] = (String)this.oColourMap.get("!".concat(poFirst).concat(poSecond));
    }
}

