/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.gff;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.biojava.bio.program.gff.GFFRecord;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.utils.SmallMap;

public class SimpleGFFRecord
implements GFFRecord {
    private String seqName;
    private String source;
    private String feature;
    private int start;
    private int end;
    private double score;
    private StrandedFeature.Strand strand;
    private int frame;
    private Map groupAttributes;
    private String comment;

    public SimpleGFFRecord(GFFRecord rec) {
        this.seqName = rec.getSeqName();
        this.source = rec.getSource();
        this.feature = rec.getFeature();
        this.start = rec.getStart();
        this.end = rec.getEnd();
        this.score = rec.getScore();
        this.strand = rec.getStrand();
        this.frame = rec.getFrame();
        this.comment = rec.getComment();
        this.groupAttributes = new SmallMap(rec.getGroupAttributes());
    }

    public SimpleGFFRecord(String seqName, String source, String feature, int start, int end, double score, StrandedFeature.Strand strand, int frame, String comment, Map groupAttributes) {
        this.seqName = seqName;
        this.source = source;
        this.feature = feature;
        this.start = start;
        this.end = end;
        this.score = score;
        this.strand = strand;
        this.frame = frame;
        this.comment = comment;
        this.groupAttributes = new SmallMap(groupAttributes);
    }

    public SimpleGFFRecord() {
        this.seqName = null;
        this.source = null;
        this.feature = null;
        this.start = 0;
        this.end = 0;
        this.score = 0.0;
        this.strand = null;
        this.frame = 0;
        this.comment = null;
        this.groupAttributes = null;
    }

    public void setSeqName(String seqName) {
        this.seqName = seqName;
    }

    public String getSeqName() {
        return this.seqName;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    public void setFeature(String feature) {
        this.feature = feature;
    }

    public String getFeature() {
        return this.feature;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getStart() {
        return this.start;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public int getEnd() {
        return this.end;
    }

    public void setScore(double score) {
        this.score = score;
    }

    public double getScore() {
        return this.score;
    }

    public void setStrand(StrandedFeature.Strand strand) {
        this.strand = strand;
    }

    public StrandedFeature.Strand getStrand() {
        return this.strand;
    }

    public void setFrame(int frame) throws IllegalArgumentException {
        if (frame != GFFRecord.NO_FRAME && (frame < 0 || frame > 2)) {
            throw new IllegalArgumentException("Illegal frame: " + frame);
        }
        this.frame = frame;
    }

    public int getFrame() {
        return this.frame;
    }

    public void setGroupAttributes(Map ga) {
        this.groupAttributes = ga;
    }

    public Map getGroupAttributes() {
        if (this.groupAttributes == null) {
            this.groupAttributes = new SmallMap();
        }
        return this.groupAttributes;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getComment() {
        return this.comment;
    }

    public static String stringifyAttributes(Map attMap) {
        String value;
        Iterator vi;
        List values;
        String key;
        StringBuffer sBuff = new StringBuffer();
        Iterator ki = attMap.keySet().iterator();
        if (ki.hasNext()) {
            key = (String)ki.next();
            sBuff.append(key);
            values = (List)attMap.get(key);
            vi = values.iterator();
            while (vi.hasNext()) {
                value = (String)vi.next();
                if (value.indexOf(" ") != -1) {
                    sBuff.append(" \"" + value + "\"");
                    continue;
                }
                sBuff.append(" " + value);
            }
        }
        while (ki.hasNext()) {
            key = (String)ki.next();
            sBuff.append("; " + key);
            values = (List)attMap.get(key);
            vi = values.iterator();
            while (vi.hasNext()) {
                value = (String)vi.next();
                if (value.indexOf(" ") != -1) {
                    sBuff.append(" \"" + value + "\"");
                    continue;
                }
                sBuff.append(" " + value);
            }
        }
        return sBuff.substring(0);
    }
}

