/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.ssaha;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.nio.LongBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.biojava.bio.BioError;
import org.biojava.bio.program.ssaha.DataStore;
import org.biojava.bio.program.ssaha.SearchListener;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Packing;
import org.biojava.bio.symbol.PackingFactory;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.Constants;
import org.biojava.utils.NestedException;
import org.biojava.utils.io.LargeBuffer;

class NIODataStore
implements DataStore {
    private final Packing packing;
    private final int wordLength;
    private final LongBuffer hashTable;
    private final LargeBuffer hitTable;
    private final MappedByteBuffer nameTable;

    NIODataStore(File dataStoreFile) throws IOException {
        FileChannel channel = new FileInputStream(dataStoreFile).getChannel();
        MappedByteBuffer rootBuffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, 3 * Constants.BYTES_IN_LONG + 2 * Constants.BYTES_IN_INT);
        rootBuffer.position(0);
        long hashTablePos = rootBuffer.getLong();
        long hitTablePos = rootBuffer.getLong();
        long nameTablePos = rootBuffer.getLong();
        this.wordLength = rootBuffer.getInt();
        int packingStreamLength = rootBuffer.getInt();
        System.out.println("hashTablePos:\t" + hashTablePos);
        System.out.println("hitTablePos:\t" + hitTablePos);
        System.out.println("nameTablePos:\t" + nameTablePos);
        System.out.println("packingStreamLength:\t" + packingStreamLength);
        rootBuffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, 3 * Constants.BYTES_IN_LONG + 2 * Constants.BYTES_IN_INT + packingStreamLength);
        rootBuffer.position(3 * Constants.BYTES_IN_LONG + 2 * Constants.BYTES_IN_INT);
        byte[] packingBuffer = new byte[packingStreamLength];
        rootBuffer.get(packingBuffer);
        ByteArrayInputStream packingStream = new ByteArrayInputStream(packingBuffer);
        ObjectInputStream packingSerializer = new ObjectInputStream(packingStream);
        try {
            this.packing = (Packing)packingSerializer.readObject();
        }
        catch (ClassNotFoundException cnfe) {
            throw new Error("Can't restore packing", cnfe);
        }
        MappedByteBuffer hashTable_MB = channel.map(FileChannel.MapMode.READ_ONLY, hashTablePos, Constants.BYTES_IN_LONG);
        hashTable_MB.position(0);
        long hashTableSize = hashTable_MB.getLong();
        System.out.println("hashTableSize: " + hashTableSize);
        this.hashTable = channel.map(FileChannel.MapMode.READ_ONLY, hashTablePos + (long)Constants.BYTES_IN_LONG, hashTableSize - (long)Constants.BYTES_IN_LONG).asLongBuffer();
        MappedByteBuffer nameTable_MB = channel.map(FileChannel.MapMode.READ_ONLY, nameTablePos, Constants.BYTES_IN_INT);
        nameTable_MB.position(0);
        int nameTableSize = nameTable_MB.getInt();
        this.nameTable = channel.map(FileChannel.MapMode.READ_ONLY, nameTablePos + (long)Constants.BYTES_IN_INT, nameTableSize - Constants.BYTES_IN_INT);
        MappedByteBuffer hitTable_MB = channel.map(FileChannel.MapMode.READ_ONLY, hitTablePos, Constants.BYTES_IN_LONG);
        hitTable_MB.position(0);
        long hitTableSize = hitTable_MB.getLong();
        this.hitTable = new LargeBuffer(channel, FileChannel.MapMode.READ_ONLY, hitTablePos + (long)Constants.BYTES_IN_LONG, hitTableSize - (long)Constants.BYTES_IN_LONG);
    }

    public FiniteAlphabet getAlphabet() {
        return this.packing.getAlphabet();
    }

    public void search(String seqID, SymbolList symList, SearchListener listener) throws NestedException {
        try {
            int word = PackingFactory.primeWord(symList, this.wordLength, this.packing);
            listener.startSearch(seqID);
            this.fireHits(word, 1, listener);
            int j = this.wordLength + 2;
            while (j <= symList.length()) {
                word = PackingFactory.nextWord(symList, word, j, this.wordLength, this.packing);
                this.fireHits(word, j - this.wordLength, listener);
                ++j;
            }
            listener.endSearch(seqID);
        }
        catch (IllegalSymbolException ise) {
            throw new BioError("Assertion Failure: Symbol dissapeared");
        }
        catch (IOException ioe) {
            throw new NestedException(ioe);
        }
    }

    public String seqNameForID(int id) throws NestedException {
        this.nameTable.position(id);
        int length = this.nameTable.getShort();
        StringBuffer sbuff = new StringBuffer(length);
        int i = 0;
        while (i < length) {
            sbuff.append(this.nameTable.getChar());
            ++i;
        }
        return sbuff.toString();
    }

    private void fireHits(int word, int offset, SearchListener listener) throws IOException {
        long hitOffset = this.hashTable.get(word);
        if (hitOffset != -1L) {
            try {
                this.hitTable.position(hitOffset);
            }
            catch (IllegalArgumentException e) {
                System.out.println("word:\t" + word);
                System.out.println("offset:\t" + offset);
                System.out.println("hitOffset\t" + hitOffset);
                throw e;
            }
            int hits = this.hitTable.getInt();
            int i = 0;
            while (i < hits) {
                listener.hit(this.hitTable.getInt(), offset, this.hitTable.getInt(), this.wordLength);
                ++i;
            }
        }
    }
}

