/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.tagvalue;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.biojava.bio.program.tagvalue.TagValueContext;
import org.biojava.bio.program.tagvalue.TagValueListener;
import org.biojava.bio.program.tagvalue.TagValueWrapper;
import org.biojava.utils.ParserException;

public class RegexFieldFinder
extends TagValueWrapper {
    private final Pattern pattern;
    private final String[] tags;
    private final boolean inLine;

    public RegexFieldFinder(TagValueListener delegate, Pattern pattern, String[] tags, boolean inLine) {
        super(delegate);
        this.pattern = pattern;
        this.tags = tags;
        this.inLine = inLine;
    }

    public void startTag(Object tag) throws ParserException {
        if (!this.inLine) {
            super.startTag(tag);
            super.startRecord();
        }
    }

    public void endTag() throws ParserException {
        if (!this.inLine) {
            super.endRecord();
            super.endTag();
        }
    }

    public void value(TagValueContext ctxt, Object val) throws ParserException {
        try {
            Matcher m = this.pattern.matcher(val.toString());
            m.find();
            int i = 0;
            while (i < this.tags.length) {
                super.startTag(this.tags[i]);
                super.value(ctxt, m.group(i + 1));
                super.endTag();
                ++i;
            }
        }
        catch (IllegalStateException ise) {
            throw new ParserException("Problem matching " + this.pattern.pattern() + " to " + val);
        }
    }
}

