/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import java.util.Iterator;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.GappedSequence;
import org.biojava.bio.seq.MergeFeatureHolder;
import org.biojava.bio.seq.ProjectedFeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SimpleFeatureHolder;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.impl.FeatureImpl;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.SimpleGappedSymbolList;
import org.biojava.utils.ChangeVetoException;

public class SimpleGappedSequence
extends SimpleGappedSymbolList
implements GappedSequence {
    private Sequence sequence;
    private MergeFeatureHolder features;
    private SimpleFeatureHolder localFeatures;
    private FeatureHolder projectedFeatures;
    private boolean createOnUnderlying;

    public SimpleGappedSequence(Sequence seq) {
        super(seq);
        this.sequence = seq;
        this.createOnUnderlying = false;
    }

    public boolean getCreateOnUnderlyingSequence() {
        return this.createOnUnderlying;
    }

    public void setCreateOnUnderlyingSequence(boolean underlying) {
        this.createOnUnderlying = underlying;
    }

    public Annotation getAnnotation() {
        return this.sequence.getAnnotation();
    }

    public String getName() {
        return this.sequence.getName();
    }

    public String getURN() {
        return this.sequence.getURN();
    }

    private FeatureHolder getFeatures() {
        if (this.features == null) {
            this.features = this.makeFeatures();
        }
        return this.features;
    }

    private MergeFeatureHolder makeFeatures() {
        this.projectedFeatures = new ProjectedFeatureHolder(this.sequence, (FeatureHolder)this, 0, false){

            public FeatureHolder getParent(Feature f) {
                return SimpleGappedSequence.this;
            }

            public Sequence getSequence(Feature f) {
                return SimpleGappedSequence.this;
            }

            public Location getLocation(Feature f) {
                return SimpleGappedSequence.this.locationToGapped(f.getLocation());
            }

            public StrandedFeature.Strand getStrand(StrandedFeature f) {
                return f.getStrand();
            }

            public Annotation getAnnotation(Feature f) {
                return f.getAnnotation();
            }

            public FeatureHolder projectChildFeatures(Feature f, FeatureHolder parent) {
                return FeatureHolder.EMPTY_FEATURE_HOLDER;
            }

            public Feature createFeature(Feature.Template templ) throws ChangeVetoException, BioException {
                templ.location = SimpleGappedSequence.this.gappedToLocation(templ.location);
                return this.projectFeature(this.getWrapped().createFeature(templ));
            }

            public void removeFeature(Feature f, Feature f2) throws ChangeVetoException {
                throw new ChangeVetoException("NO");
            }

            public FeatureFilter getSchema(Feature f) {
                return f.getSchema();
            }
        };
        this.localFeatures = new SimpleFeatureHolder();
        this.features = new MergeFeatureHolder();
        try {
            this.features.addFeatureHolder(this.projectedFeatures);
            this.features.addFeatureHolder(this.localFeatures);
        }
        catch (ChangeVetoException cve) {
            throw new BioError(cve, "Assertion Failure: Should be able to do this");
        }
        return this.features;
    }

    public Iterator features() {
        return this.getFeatures().features();
    }

    public FeatureHolder filter(FeatureFilter ff) {
        return this.getFeatures().filter(ff);
    }

    public FeatureHolder filter(FeatureFilter ff, boolean recurse) {
        return this.getFeatures().filter(ff, recurse);
    }

    public int countFeatures() {
        return this.getFeatures().countFeatures();
    }

    public boolean containsFeature(Feature f) {
        return this.getFeatures().containsFeature(f);
    }

    public FeatureFilter getSchema() {
        return this.getFeatures().getSchema();
    }

    public void removeFeature(Feature f) throws ChangeVetoException {
        this.getFeatures().removeFeature(f);
    }

    public Feature createFeature(Feature.Template templ) throws ChangeVetoException, BioException {
        this.getFeatures();
        if (this.createOnUnderlying) {
            return this.projectedFeatures.createFeature(templ);
        }
        Feature f = FeatureImpl.DEFAULT.realizeFeature(this, this, templ);
        this.localFeatures.addFeature(f);
        return f;
    }
}

