/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db.flat;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.NoSuchElementException;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioException;
import org.biojava.bio.program.indexdb.BioStore;
import org.biojava.bio.program.indexdb.Record;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.db.IllegalIDException;
import org.biojava.bio.seq.db.SequenceDBLite;
import org.biojava.bio.seq.io.SeqIOTools;
import org.biojava.bio.seq.io.SequenceBuilderFactory;
import org.biojava.bio.seq.io.SequenceFormat;
import org.biojava.bio.seq.io.StreamReader;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.Unchangeable;
import org.biojava.utils.io.RAF;
import org.biojava.utils.lsid.LifeScienceIdentifier;
import org.biojava.utils.lsid.LifeScienceIdentifierParseException;

public class FlatSequenceDB
extends Unchangeable
implements SequenceDBLite {
    private BioStore index;
    private String dbName;
    private LifeScienceIdentifier format;

    public FlatSequenceDB(String location, String dbName) throws IOException, BioException {
        this.dbName = dbName;
        this.index = new BioStore(new File(location), false);
        try {
            Annotation config = this.index.getMetaData();
            String lsid = (String)config.getProperty("format");
            this.format = LifeScienceIdentifier.valueOf(lsid);
        }
        catch (NoSuchElementException nsee) {
            throw new BioException(nsee, "Malformed OBDA index '" + location + "' does not indicate sequence format");
        }
        catch (LifeScienceIdentifierParseException lse) {
            throw new BioException(lse, "Malformed OBDA index '" + location + "' has a format identifier which is not a valid LSID");
        }
    }

    public String getName() {
        return this.dbName;
    }

    public Sequence getSequence(String id) throws IllegalIDException, BioException {
        try {
            Record record = this.index.get(id);
            RAF seqRAF = record.getFile();
            int recLength = record.getLength();
            seqRAF.seek(record.getOffset());
            byte[] bytes = new byte[recLength];
            seqRAF.readFully(bytes, 0, recLength);
            ByteArrayInputStream is = new ByteArrayInputStream(bytes);
            int formatId = SeqIOTools.identifyFormat(this.format.getNamespaceId(), this.format.getObjectId());
            SequenceFormat sf = SeqIOTools.getSequenceFormat(formatId);
            FiniteAlphabet alpha = SeqIOTools.getAlphabet(formatId);
            SymbolTokenization toke = alpha.getTokenization("token");
            SequenceBuilderFactory sbf = SeqIOTools.getBuilderFactory(formatId);
            StreamReader si = new StreamReader(is, sf, toke, sbf);
            return si.nextSequence();
        }
        catch (NoSuchElementException nsee) {
            throw new IllegalIDException("Failed to find sequence with ID " + id + " in database " + this.getName());
        }
        catch (IOException ioe) {
            throw new BioException(ioe, "Failed to retrieve sequence with ID " + id);
        }
    }

    public void addSequence(Sequence sequence) throws ChangeVetoException {
        throw new ChangeVetoException("Failed to add sequence. Sequences may not be added to a flat database");
    }

    public void removeSequence(String id) throws ChangeVetoException {
        throw new ChangeVetoException("Failed to add sequence. Sequences may not be removed from a flat database");
    }
}

