/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.biojava.bio.BioError;
import org.biojava.bio.seq.ComponentFeature;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.symbol.AbstractSymbolList;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.NestedError;

public class AssembledSymbolList
extends AbstractSymbolList {
    private boolean autoLength = true;
    private int length = 0;
    private SortedMap components;
    private List componentList;
    private final Symbol noninformativeSymbol = DNATools.n();
    private final char noninformativeToken = (char)110;
    private Location lastLocation;

    public AssembledSymbolList() {
        this.components = new TreeMap(Location.naturalOrder);
        this.componentList = new ArrayList();
        this.lastLocation = Location.empty;
    }

    public void setLength(int len) {
        this.autoLength = false;
        this.length = len;
    }

    public void putComponent(ComponentFeature f) {
        this.components.put(f.getLocation(), f);
        this.componentList.clear();
        this.componentList.addAll(this.components.keySet());
    }

    public void putComponent(Location l, SymbolList sl) {
        if (sl == this) {
            throw new NestedError("Circular reference");
        }
        this.components.put(l, sl);
        this.componentList.clear();
        this.componentList.addAll(this.components.keySet());
    }

    public void removeComponent(Location loc) {
        this.components.remove(loc);
        this.componentList.clear();
        this.componentList.addAll(this.components.keySet());
    }

    private SymbolList getComponentSymbols(Location loc) {
        Object o = this.components.get(loc);
        if (o instanceof ComponentFeature) {
            ComponentFeature cf = (ComponentFeature)o;
            SymbolList sl = cf.getSymbols();
            if (cf.getStrand() == StrandedFeature.NEGATIVE) {
                try {
                    sl = DNATools.reverseComplement(sl);
                }
                catch (IllegalAlphabetException ex) {
                    throw new BioError("Assertion failed: couldn't reverse-complement component symbols");
                }
            }
            return sl;
        }
        return (SymbolList)o;
    }

    public Set getComponentLocationSet() {
        return this.components.keySet();
    }

    private Location locationOfPoint(int p) {
        if (this.lastLocation.contains(p)) {
            return this.lastLocation;
        }
        int first = 0;
        int last = this.componentList.size() - 1;
        while (first <= last) {
            int check = (first + last) / 2;
            Location checkL = (Location)this.componentList.get(check);
            if (checkL.contains(p)) {
                this.lastLocation = checkL;
                return checkL;
            }
            if (p < checkL.getMin()) {
                last = check - 1;
                continue;
            }
            first = check + 1;
        }
        return null;
    }

    private Location locationUpstreamOfPoint(int p) {
        int first = 0;
        int last = this.componentList.size() - 1;
        int check = 0;
        Location checkL = null;
        while (first <= last) {
            check = (first + last) / 2;
            checkL = (Location)this.componentList.get(check);
            if (checkL.contains(p)) {
                return checkL;
            }
            if (p < checkL.getMin()) {
                last = check - 1;
                continue;
            }
            first = check + 1;
        }
        try {
            if (p < checkL.getMin()) {
                return checkL;
            }
            return (Location)this.componentList.get(check + 1);
        }
        catch (IndexOutOfBoundsException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public Alphabet getAlphabet() {
        return DNATools.getDNA();
    }

    public int length() {
        if (this.autoLength) {
            int componentCount = this.componentList.size();
            if (componentCount == 0) {
                return 0;
            }
            Location last = (Location)this.componentList.get(componentCount - 1);
            return last.getMax();
        }
        return this.length;
    }

    public Symbol symbolAt(int pos) {
        Location l = this.locationOfPoint(pos);
        if (l != null) {
            SymbolList syms = this.getComponentSymbols(l);
            return syms.symbolAt(pos - l.getMin() + 1);
        }
        return this.noninformativeSymbol;
    }

    public SymbolList subList(int start, int end) {
        Location l = this.locationOfPoint(start);
        if (l != null && l.contains(end)) {
            SymbolList symbols = this.getComponentSymbols(l);
            int tstart = start - l.getMin() + 1;
            int tend = end - l.getMin() + 1;
            return symbols.subList(tstart, tend);
        }
        return super.subList(start, end);
    }

    public String subStr(int start, int end) {
        if (start < 1 || end > this.length()) {
            throw new IndexOutOfBoundsException("Range out of bounds: " + start + " - " + end);
        }
        StringBuffer sb = new StringBuffer();
        int pos = start;
        while (pos <= end) {
            int numNs;
            Location loc = this.locationOfPoint(pos);
            if (loc != null) {
                SymbolList sl = this.getComponentSymbols(loc);
                int slStart = Math.max(1, pos - loc.getMin() + 1);
                int slEnd = Math.min(loc.getMax() - loc.getMin() + 1, end - loc.getMin() + 1);
                sb.append(sl.subStr(slStart, slEnd));
                pos += slEnd - slStart + 1;
                continue;
            }
            loc = this.locationUpstreamOfPoint(pos);
            if (loc != null) {
                numNs = Math.min(loc.getMin(), end + 1) - pos;
                pos = loc.getMin();
            } else {
                numNs = end - pos + 1;
                pos = end + 1;
            }
            int i = 0;
            while (i < numNs) {
                sb.append('n');
                ++i;
            }
        }
        return sb.substring(0);
    }
}

