/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.io.AbstractGenEmblFileFormer;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SeqFileFormer;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;

public class EmblFileFormer
extends AbstractGenEmblFileFormer
implements SeqFileFormer {
    private static List NON_SEPARATED_TAGS = new ArrayList();
    private static String FT_LEADER;
    private static String SQ_LEADER;
    private static String EMPTY_LINE;
    private PrintStream stream;
    private String idLine;
    private String accLine;

    protected EmblFileFormer() {
        this(System.out);
    }

    protected EmblFileFormer(PrintStream stream) {
        this.stream = stream;
    }

    public PrintStream getPrintStream() {
        return this.stream;
    }

    public void setPrintStream(PrintStream stream) {
        this.stream = stream;
    }

    public void setName(String id) throws ParseException {
        this.idLine = id;
    }

    public void startSequence() throws ParseException {
        this.aCount = 0;
        this.cCount = 0;
        this.gCount = 0;
        this.tCount = 0;
        this.oCount = 0;
    }

    public void endSequence() throws ParseException {
        this.stream.println("//");
    }

    public void setURI(String uri) throws ParseException {
    }

    public void addSymbols(Alphabet alpha, Symbol[] syms, int start, int length) throws IllegalAlphabetException {
        try {
            int end = start + length - 1;
            int i = start;
            while (i <= end) {
                Symbol sym = syms[i];
                if (sym == this.a) {
                    ++this.aCount;
                } else if (sym == this.c) {
                    ++this.cCount;
                } else if (sym == this.g) {
                    ++this.gCount;
                } else if (sym == this.t) {
                    ++this.tCount;
                } else {
                    ++this.oCount;
                }
                ++i;
            }
            StringBuffer sb = new StringBuffer("XX");
            sb.append(this.nl);
            sb.append("SQ   Sequence ");
            sb.append(length + " BP; ");
            sb.append(this.aCount + " A; ");
            sb.append(this.cCount + " C; ");
            sb.append(this.gCount + " G; ");
            sb.append(this.tCount + " T; ");
            sb.append(this.oCount + " other;");
            this.stream.println(sb);
            int fullLine = length / 60;
            int partLine = length % 60;
            int lineCount = fullLine;
            if (partLine > 0) {
                ++lineCount;
            }
            int[] lineLens = new int[lineCount];
            Arrays.fill(lineLens, 60);
            if (partLine > 0) {
                lineLens[lineCount - 1] = partLine;
            }
            int i2 = 0;
            while (i2 < lineLens.length) {
                StringBuffer sq = new StringBuffer(EMPTY_LINE);
                int len = lineLens[i2];
                Symbol[] sa = new Symbol[len];
                System.arraycopy(syms, start + i2 * 60, sa, 0, len);
                sb = new StringBuffer();
                String blocks = this.formatTokenBlock(sb, sa, 10, this.dnaTokenization).toString();
                sq.replace(5, blocks.length() + 5, blocks);
                String count = Integer.toString(i2 * 60 + len);
                sq.replace(80 - count.length(), 80, count);
                this.stream.println(sq);
                ++i2;
            }
        }
        catch (IllegalSymbolException ex) {
            throw new IllegalAlphabetException(ex, "DNA not tokenizing");
        }
    }

    public void addSequenceProperty(Object key, Object value) throws ParseException {
        StringBuffer sb = new StringBuffer();
        if (key.equals("XX")) {
            return;
        }
        String tag = key.toString();
        String leader = tag + SQ_LEADER;
        String line = "";
        int wrapWidth = 80 - leader.length();
        if (key.equals("embl_accessions")) {
            this.accLine = this.buildPropertyLine((Collection)value, ";", true);
            return;
        }
        if (key.equals("AC")) {
            line = this.accLine;
        }
        if (value instanceof String) {
            line = (String)value;
        } else if (value instanceof Collection) {
            if (key.equals("DT")) {
                line = this.buildPropertyLine((Collection)value, this.nl + leader, false);
                wrapWidth = Integer.MAX_VALUE;
            } else {
                line = this.buildPropertyLine((Collection)value, " ", false);
            }
        }
        if (line.length() == 0) {
            this.stream.println(tag);
        } else {
            sb = this.formatSequenceProperty(sb, line, leader, wrapWidth);
            this.stream.println(sb);
        }
        if (!NON_SEPARATED_TAGS.contains(key)) {
            this.stream.println("XX");
        }
        if (key.equals("FH")) {
            this.stream.println("FH");
        }
    }

    public void startFeature(Feature.Template templ) throws ParseException {
        int strand = 0;
        if (templ instanceof StrandedFeature.Template) {
            strand = ((StrandedFeature.Template)templ).strand.getValue();
        }
        StringBuffer sb = new StringBuffer(FT_LEADER);
        sb = this.formatLocationBlock(sb, templ.location, strand, FT_LEADER, 80);
        sb.replace(5, 5 + templ.type.length(), templ.type);
        this.stream.println(sb);
    }

    public void endFeature() throws ParseException {
    }

    public void addFeatureProperty(Object key, Object value) throws ParseException {
        if (key.equals("internal_data")) {
            return;
        }
        if (value instanceof Collection) {
            Iterator vi = ((Collection)value).iterator();
            while (vi.hasNext()) {
                StringBuffer fb = new StringBuffer();
                StringBuffer sb = new StringBuffer();
                fb = this.formatQualifierBlock(fb, this.formatQualifier(sb, key, vi.next()).substring(0), FT_LEADER, 80);
                this.stream.println(fb);
            }
        } else {
            StringBuffer fb = new StringBuffer();
            StringBuffer sb = new StringBuffer();
            fb = this.formatQualifierBlock(fb, this.formatQualifier(sb, key, value).substring(0), FT_LEADER, 80);
            this.stream.println(fb);
        }
    }

    private String buildPropertyLine(Collection property, String separator, boolean terminate) {
        StringBuffer sb = new StringBuffer();
        Iterator pi = property.iterator();
        while (pi.hasNext()) {
            sb.append(pi.next().toString());
            sb.append(separator);
        }
        if (terminate) {
            return sb.substring(0);
        }
        return sb.substring(0, sb.length() - separator.length());
    }

    static {
        NON_SEPARATED_TAGS.add("OS");
        NON_SEPARATED_TAGS.add("RN");
        NON_SEPARATED_TAGS.add("RP");
        NON_SEPARATED_TAGS.add("RX");
        NON_SEPARATED_TAGS.add("RA");
        NON_SEPARATED_TAGS.add("RT");
        NON_SEPARATED_TAGS.add("FH");
        FT_LEADER = "FT                   ";
        SQ_LEADER = "   ";
        EMPTY_LINE = "                                                                                ";
    }
}

