/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.Serializable;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.symbol.AbstractSymbolList;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetIndex;
import org.biojava.bio.symbol.FullDnaAlphabetIndex;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;

public class PackedDnaSymbolList
extends AbstractSymbolList
implements Serializable {
    int length = 0;
    int log2PackedSymsPerStorageUnit = 1;
    int packedSymsPerStorageUnit = 0;
    int storageUnitOffsetMask = 1;
    int storageUnitSize = 0;
    byte[] packedSymbolArray = null;
    int log2SymsPerCacheLine = 4;
    int cacheLineOffsetMask = 15;
    Symbol[] symbolCache = null;
    int currCacheIndex = -1;
    int cacheLineCount = 0;
    int symsInFinalStorageUnit = 0;
    int symsInFinalCacheLine = 0;
    int fullStorageUnitsInFinalCacheLine = 0;
    int log2StorageUnitsPerCacheLine = 0;
    int storageUnitsPerCacheLine = 0;
    static AlphabetIndex alfaIndex = null;

    public PackedDnaSymbolList(SymbolList symList) throws BioException, IllegalAlphabetException {
        if (symList.getAlphabet() != DNATools.getDNA()) {
            throw new IllegalAlphabetException();
        }
        this.symbolCache = new Symbol[1 << this.log2SymsPerCacheLine];
        this.log2StorageUnitsPerCacheLine = this.log2SymsPerCacheLine - this.log2PackedSymsPerStorageUnit;
        this.storageUnitsPerCacheLine = 1 << this.log2StorageUnitsPerCacheLine;
        this.packedSymsPerStorageUnit = 1 << this.log2PackedSymsPerStorageUnit;
        this.length = symList.length();
        this.storageUnitSize = this.length >> this.log2PackedSymsPerStorageUnit;
        this.symsInFinalStorageUnit = this.length & this.storageUnitOffsetMask;
        this.packedSymbolArray = this.symsInFinalStorageUnit == 0 ? new byte[this.storageUnitSize] : new byte[this.storageUnitSize + 1];
        this.cacheLineCount = this.length >> this.log2SymsPerCacheLine;
        this.symsInFinalCacheLine = this.length & this.cacheLineOffsetMask;
        this.fullStorageUnitsInFinalCacheLine = this.symsInFinalCacheLine >> this.log2PackedSymsPerStorageUnit;
        if (alfaIndex == null) {
            alfaIndex = new FullDnaAlphabetIndex();
        }
        int symbolPointer = 1;
        int bytePointer = 0;
        int currByte = 0;
        int i = 0;
        while (i < this.storageUnitSize) {
            int j = 0;
            while (j < 2) {
                currByte = (byte)(currByte << 4 | alfaIndex.indexForSymbol(symList.symbolAt(symbolPointer)));
                ++symbolPointer;
                ++j;
            }
            this.packedSymbolArray[bytePointer] = currByte;
            ++bytePointer;
            ++i;
        }
        currByte = 0;
        if (this.symsInFinalStorageUnit != 0) {
            int i2 = 0;
            while (i2 < this.symsInFinalStorageUnit) {
                currByte = (byte)(currByte << 4 | alfaIndex.indexForSymbol(symList.symbolAt(symbolPointer)));
                ++symbolPointer;
                ++i2;
            }
            this.packedSymbolArray[bytePointer] = currByte;
        }
    }

    public PackedDnaSymbolList(int length, byte[] byteArray) throws BioException {
        this.storageUnitSize = length >> this.log2PackedSymsPerStorageUnit;
        this.symsInFinalStorageUnit = length & this.storageUnitOffsetMask;
        int expectedArraySize = this.symsInFinalStorageUnit == 0 ? this.storageUnitSize : this.storageUnitSize + 1;
        if (byteArray.length < expectedArraySize) {
            throw new BioException("array is too small to represent given sequence length.");
        }
        this.packedSymbolArray = byteArray;
    }

    public int length() {
        return this.length;
    }

    public Alphabet getAlphabet() {
        return DNATools.getDNA();
    }

    public Symbol symbolAt(int index) {
        if (index < 1) {
            throw new IndexOutOfBoundsException("");
        }
        if (index > this.length) {
            throw new IndexOutOfBoundsException("");
        }
        int cacheIndex = index - 1 >> this.log2SymsPerCacheLine;
        int cacheOffset = index - 1 & this.cacheLineOffsetMask;
        if (this.currCacheIndex != cacheIndex) {
            int storageUnitIndex = cacheIndex << this.log2StorageUnitsPerCacheLine;
            if (cacheIndex == this.cacheLineCount && this.symsInFinalCacheLine != 0) {
                int symIndex = 0;
                int currStorageUnit = -1;
                if (this.fullStorageUnitsInFinalCacheLine != 0) {
                    int i = 0;
                    while (i < this.fullStorageUnitsInFinalCacheLine) {
                        currStorageUnit = this.packedSymbolArray[storageUnitIndex];
                        int j = this.packedSymsPerStorageUnit - 1;
                        while (j >= 0) {
                            this.symbolCache[symIndex + j] = alfaIndex.symbolForIndex(currStorageUnit & 0xF);
                            currStorageUnit = (byte)(currStorageUnit >> 4);
                            --j;
                        }
                        symIndex += this.packedSymsPerStorageUnit;
                        ++storageUnitIndex;
                        ++i;
                    }
                }
                if (this.symsInFinalStorageUnit != 0) {
                    currStorageUnit = this.packedSymbolArray[storageUnitIndex];
                    int j = this.symsInFinalStorageUnit - 1;
                    while (j >= 0) {
                        this.symbolCache[symIndex + j] = alfaIndex.symbolForIndex(currStorageUnit & 0xF);
                        currStorageUnit = (byte)(currStorageUnit >> 4);
                        --j;
                    }
                }
            } else {
                int symIndex = 0;
                int i = 0;
                while (i < this.storageUnitsPerCacheLine) {
                    byte currStorageUnit = this.packedSymbolArray[storageUnitIndex];
                    int j = this.packedSymsPerStorageUnit - 1;
                    while (j >= 0) {
                        this.symbolCache[symIndex + j] = alfaIndex.symbolForIndex(currStorageUnit & 0xF);
                        currStorageUnit = (byte)(currStorageUnit >> 4);
                        --j;
                    }
                    symIndex += this.packedSymsPerStorageUnit;
                    ++storageUnitIndex;
                    ++i;
                }
            }
            this.currCacheIndex = cacheIndex;
        }
        return this.symbolCache[cacheOffset];
    }

    public byte[] getArray() {
        return this.packedSymbolArray;
    }
}

