/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.ReversibleTranslationTable;
import org.biojava.bio.symbol.SimpleTranslationTable;
import org.biojava.bio.symbol.Symbol;

public class SimpleReversibleTranslationTable
extends SimpleTranslationTable
implements ReversibleTranslationTable,
Serializable {
    private Map revMap;

    public void setTranslation(AtomicSymbol from, AtomicSymbol to) throws IllegalSymbolException {
        super.setTranslation(from, to);
        this.revMap.put(to, from);
    }

    public Symbol untranslate(Symbol sym) throws IllegalSymbolException {
        Symbol s = (Symbol)this.revMap.get(sym);
        if (s == null) {
            if (s instanceof AtomicSymbol) {
                this.getTargetAlphabet().validate(sym);
                throw new IllegalSymbolException("Unable to map " + sym.getName());
            }
            HashSet<Symbol> syms = new HashSet<Symbol>();
            Iterator i = ((FiniteAlphabet)s.getMatches()).iterator();
            while (i.hasNext()) {
                Symbol is = (Symbol)i.next();
                syms.add(this.untranslate(is));
            }
            s = this.getSourceAlphabet().getAmbiguity(syms);
        }
        return s;
    }

    public SimpleReversibleTranslationTable(FiniteAlphabet source, FiniteAlphabet target) throws IllegalAlphabetException {
        super(source, target);
        if (source.size() != target.size()) {
            throw new IllegalAlphabetException("Couldn't create translation table as the alphabets were different sizes: " + source.size() + ":" + source.getName() + target.size() + ":" + target.getName());
        }
        this.revMap = new HashMap();
    }
}

