/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.biojava.bio.symbol.AlphabetIndex;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;

public class SuffixTree
implements Serializable {
    private FiniteAlphabet alphabet;
    private SuffixNode root;
    private AlphabetIndex indexer;
    private List counts;

    public FiniteAlphabet getAlphabet() {
        return this.alphabet;
    }

    public SuffixNode getRoot() {
        return this.root;
    }

    public SuffixNode getChild(SuffixNode node, Symbol s) throws IllegalSymbolException {
        if (!this.getAlphabet().contains(s)) {
            return null;
        }
        int index = this.indexer.indexForSymbol(s);
        return this.getChild(node, index);
    }

    public SuffixNode getChild(SuffixNode node, int i) {
        if (!node.hasChild(i)) {
            node.addChild(this, i, new SimpleNode(this.alphabet.size()));
        }
        return node.getChild(i);
    }

    public void addSymbols(SymbolList sList, int window) throws IllegalSymbolException {
        SuffixNode[] buf = new SuffixNode[window];
        int[] counts = new int[window];
        int i = 0;
        while (i < window) {
            buf[i] = this.getRoot();
            ++i;
        }
        int p = 1;
        while (p <= sList.length()) {
            Symbol s = sList.symbolAt(p);
            buf[p % window] = this.getRoot();
            int i2 = 0;
            while (i2 < window) {
                int pi = (p + i2) % window;
                if (buf[pi] != null) {
                    buf[pi] = this.getChild(buf[pi], s);
                    if (buf[pi] != null) {
                        int n = i2;
                        counts[n] = counts[n] + 1;
                        buf[pi].setNumber(buf[pi].getNumber() + 1.0f);
                    }
                }
                ++i2;
            }
            ++p;
        }
        int i3 = 0;
        while (i3 < window) {
            this.incCounts(i3 + 1, counts[i3]);
            ++i3;
        }
    }

    protected void incCounts(int i, int c) {
        if (i < this.counts.size()) {
            Integer oldC = (Integer)this.counts.get(i - 1);
            Integer newC = new Integer(oldC + c);
            this.counts.set(i - 1, newC);
        } else {
            this.counts.add(new Integer(c));
        }
    }

    public int maxLength() {
        return this.counts.size();
    }

    public int frequency(int length) {
        return (Integer)this.counts.get(length - 1);
    }

    public SuffixTree(FiniteAlphabet alphabet) {
        this.alphabet = alphabet;
        this.indexer = AlphabetManager.getAlphabetIndex(alphabet);
        this.counts = new ArrayList();
        this.root = new SimpleNode(alphabet.size());
    }

    private static class SimpleNode
    extends SuffixNode {
        private float number = 0.0f;
        private SuffixNode[] child;

        private SuffixNode[] childArray(SuffixTree tree) {
            if (this.child == null) {
                this.child = new SuffixNode[tree.getAlphabet().size()];
            }
            return this.child;
        }

        public boolean isTerminal() {
            return false;
        }

        public boolean hasChild(int i) {
            return this.child != null && this.child[i] != null;
        }

        public float getNumber() {
            return this.number;
        }

        SuffixNode getChild(int i) {
            if (this.hasChild(i)) {
                return this.child[i];
            }
            return null;
        }

        void addChild(SuffixTree tree, int i, SuffixNode n) {
            this.childArray((SuffixTree)tree)[i] = n;
        }

        public void setNumber(float n) {
            this.number = n;
        }

        SimpleNode(int c) {
            this.child = new SuffixNode[c];
        }
    }

    public static abstract class SuffixNode
    implements Serializable {
        public abstract boolean isTerminal();

        public abstract boolean hasChild(int var1);

        public abstract float getNumber();

        public abstract void setNumber(float var1);

        abstract SuffixNode getChild(int var1);

        abstract void addChild(SuffixTree var1, int var2, SuffixNode var3);
    }
}

