/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import org.biojava.bio.BioError;
import org.biojava.bio.symbol.AbstractSymbolList;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.bio.symbol.TranslationTable;

class TranslatedSymbolList
extends AbstractSymbolList
implements SymbolList {
    private final SymbolList source;
    private final TranslationTable transTable;

    public TranslationTable getTranslationTable() {
        return this.transTable;
    }

    public SymbolList getSource() {
        return this.source;
    }

    public TranslatedSymbolList(SymbolList source, TranslationTable transTable) throws IllegalAlphabetException {
        if (transTable.getSourceAlphabet() != source.getAlphabet()) {
            throw new IllegalAlphabetException("The source alphabet and translation table source alphabets don't match: " + source.getAlphabet().getName() + " and " + transTable.getSourceAlphabet().getName());
        }
        this.source = source;
        this.transTable = transTable;
    }

    public int length() {
        return this.source.length();
    }

    public Symbol symbolAt(int indx) {
        try {
            return this.transTable.translate(this.source.symbolAt(indx));
        }
        catch (IllegalSymbolException ire) {
            throw new BioError(ire, "I thought that I had checked that the translation table was compatible with my source, but apparently something has messed up.");
        }
    }

    public Alphabet getAlphabet() {
        return this.transTable.getTargetAlphabet();
    }
}

