/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class JembossParams {
    public static final int SERVER_OK = 0;
    public static final int SERVER_ERR = 1;
    public static final int SERVER_DOWN = 2;
    private boolean useHTTPSProxy;
    private String useHTTPSProxyName;
    private boolean useProxy;
    private String useProxyName;
    private String proxyHost;
    private String proxyHostName;
    private int proxyPortNum;
    private String proxyPortNumName;
    private boolean useBrowserProxy;
    private String useBrowserProxyName;
    private String browserProxyHost;
    private String browserProxyHostName;
    private int browserProxyPort;
    private String browserProxyPortName;
    private boolean useTFM;
    private String useTFMName;
    private boolean useProxyAuth;
    private String useProxyAuthName;
    private String proxyAuthUser;
    private String proxyAuthUserName;
    private String proxyAuthPasswd;
    private String proxyAuthPasswdName;
    private boolean proxyOverride;
    private String proxyOverrideName;
    private boolean useAuth;
    private String useAuthName;
    private String publicSoapURL;
    private String publicSoapURLName;
    private String privateSoapURL;
    private String privateSoapURLName;
    private String soapService;
    private String soapServiceName;
    private String privateSoapService;
    private String privateSoapServiceName;
    private String publicSoapService;
    private String publicSoapServiceName;
    private boolean debug;
    private String debugName;
    private boolean hasBatchMode;
    private String hasBatchModeName;
    private boolean hasInteractiveMode;
    private String hasInteractiveModeName;
    private String currentMode;
    private String currentModeName;
    private String serverPublicList;
    private String serverPublicListName;
    private String serverPrivateList;
    private String serverPrivateListName;
    private String serviceUserName;
    private String serviceUserNameName;
    private char[] servicePasswd;
    private byte[] servicePasswdByte;
    Properties jembossSettings;
    private boolean useJavaProxy;
    private String javaProxyPort;
    private String javaProxyHost;
    private boolean useJavaNoProxy;
    private String javaNoProxy;
    private Vector javaNoProxyEntries;
    private int javaProxyPortNum;
    private boolean publicServerFailOver;
    private boolean privateServerFailOver;
    private Hashtable serverStatusHash;
    private Vector publicServers;
    private Vector privateServers;
    private static boolean jembossServer = false;
    private String jembossServerName;
    private static String cygwin = null;
    private String cygwinName;
    private String plplot;
    private String plplotName;
    private String embossData;
    private String embossDataName;
    private String embossBin;
    private String embossBinName;
    private String embossPath;
    private String embossPathName;
    private String embossEnvironment;
    private String embossEnvironmentName;
    private String acdDirToParse;
    private String acdDirToParseName;
    private String embURL;
    private String embossURL;
    private String userHome;
    private String userHomeName;

    public JembossParams() {
        block6: {
            this.useHTTPSProxy = false;
            this.useHTTPSProxyName = "useHTTPSProxy";
            this.useProxy = false;
            this.useProxyName = "proxy.use";
            this.proxyHost = "wwwcache";
            this.proxyHostName = "proxy.host";
            this.proxyPortNum = 8080;
            this.proxyPortNumName = "proxy.port";
            this.useBrowserProxy = false;
            this.useBrowserProxyName = "browserProxy.use";
            this.browserProxyHost = "wwwcache";
            this.browserProxyHostName = "browserProxy.host";
            this.browserProxyPort = 8080;
            this.browserProxyPortName = "browserProxy.port";
            this.useTFMName = "tfm.use";
            this.useProxyAuth = false;
            this.useProxyAuthName = "proxy.auth";
            this.proxyAuthUser = "";
            this.proxyAuthUserName = "proxy.user";
            this.proxyAuthPasswd = "";
            this.proxyAuthPasswdName = "proxy.passwd";
            this.proxyOverride = false;
            this.proxyOverrideName = "proxy.override";
            this.useAuth = true;
            this.useAuthName = "user.auth";
            this.publicSoapURL = "https://jemboss.hgmp.mrc.ac.uk:8443/axis/services";
            this.publicSoapURLName = "server.public";
            this.privateSoapURL = "https://jemboss.hgmp.mrc.ac.uk:8443/axis/services";
            this.privateSoapURLName = "server.private";
            this.soapService = "EmbossSoap";
            this.soapServiceName = "service.name";
            this.privateSoapService = "JembossAuthServer";
            this.privateSoapServiceName = "service.private";
            this.publicSoapService = "JembossAuthServer";
            this.publicSoapServiceName = "service.public";
            this.debug = false;
            this.debugName = "jemboss.debug";
            this.hasBatchMode = true;
            this.hasBatchModeName = "jemboss.hasbatchmode";
            this.hasInteractiveMode = true;
            this.hasInteractiveModeName = "jemboss.hasinteractivemode";
            this.currentMode = "interactive";
            this.currentModeName = "jemboss.mode";
            this.serverPublicList = "";
            this.serverPublicListName = "server.publiclist";
            this.serverPrivateList = "";
            this.serverPrivateListName = "server.privatelist";
            this.serviceUserName = "";
            this.serviceUserNameName = "user.name";
            this.servicePasswd = null;
            this.servicePasswdByte = null;
            this.useJavaProxy = false;
            this.javaProxyPort = "";
            this.javaProxyHost = "";
            this.useJavaNoProxy = false;
            this.javaNoProxy = "";
            this.javaProxyPortNum = 8080;
            this.publicServerFailOver = false;
            this.privateServerFailOver = false;
            this.jembossServerName = "jemboss.server";
            this.cygwinName = "cygwin";
            this.plplot = "/usr/local/share/EMBOSS/";
            this.plplotName = "plplot";
            this.embossData = "/usr/local/share/EMBOSS/data/";
            this.embossDataName = "embossData";
            this.embossBin = "/usr/local/bin/";
            this.embossBinName = "embossBin";
            this.embossPath = "/usr/bin/:/bin";
            this.embossPathName = "embossPath";
            this.embossEnvironment = "";
            this.embossEnvironmentName = "embossEnvironment";
            this.acdDirToParse = "/usr/local/share/EMBOSS/acd/";
            this.acdDirToParseName = "acdDirToParse";
            this.embURL = "http://www.uk.embnet.org/Software/EMBOSS/Apps/";
            this.embossURL = "embossURL";
            this.userHome = System.getProperty("user.home");
            this.userHomeName = "user.home";
            Properties properties = new Properties();
            ClassLoader classLoader = this.getClass().getClassLoader();
            this.serverStatusHash = new Hashtable();
            this.publicServers = new Vector();
            this.privateServers = new Vector();
            properties.put(this.userHomeName, this.userHome);
            properties.put(this.embossURL, this.embURL);
            properties.put(this.plplotName, this.plplot);
            properties.put(this.embossDataName, this.embossData);
            properties.put(this.embossBinName, this.embossBin);
            properties.put(this.embossPathName, this.embossPath);
            properties.put(this.embossEnvironmentName, this.embossEnvironment);
            properties.put(this.acdDirToParseName, this.acdDirToParse);
            properties.put(this.useBrowserProxyName, new Boolean(this.useBrowserProxy).toString());
            properties.put(this.browserProxyHostName, this.browserProxyHost);
            properties.put(this.browserProxyPortName, new Integer(this.browserProxyPort).toString());
            properties.put(this.useTFMName, new Boolean(this.useTFM).toString());
            properties.put(this.useProxyName, new Boolean(this.useProxy).toString());
            properties.put(this.useHTTPSProxyName, new Boolean(this.useHTTPSProxy).toString());
            properties.put(this.proxyHostName, this.proxyHost);
            properties.put(this.proxyPortNumName, new Integer(this.proxyPortNum).toString());
            properties.put(this.useProxyAuthName, new Boolean(this.useProxyAuth).toString());
            properties.put(this.proxyAuthUserName, this.proxyAuthUser);
            properties.put(this.proxyAuthPasswdName, this.proxyAuthPasswd);
            properties.put(this.proxyOverrideName, new Boolean(this.proxyOverride).toString());
            properties.put(this.useAuthName, new Boolean(this.useAuth).toString());
            properties.put(this.publicSoapURLName, this.publicSoapURL);
            properties.put(this.privateSoapURLName, this.privateSoapURL);
            properties.put(this.privateSoapServiceName, this.privateSoapService);
            properties.put(this.publicSoapServiceName, this.publicSoapService);
            properties.put(this.debugName, new Boolean(this.debug).toString());
            properties.put(this.hasBatchModeName, new Boolean(this.hasBatchMode).toString());
            properties.put(this.hasInteractiveModeName, new Boolean(this.hasInteractiveMode).toString());
            properties.put(this.currentModeName, this.currentMode);
            properties.put(this.serverPublicListName, this.serverPublicList);
            properties.put(this.serverPrivateListName, this.serverPrivateList);
            properties.put(this.serviceUserNameName, this.serviceUserName);
            this.jembossSettings = new Properties(properties);
            try {
                this.jembossSettings.load(classLoader.getResourceAsStream("resources/jemboss.properties"));
            }
            catch (Exception exception) {
                if (!this.debug) break block6;
                System.out.println("Didn't find properties file in classpath.");
            }
        }
        this.loadIn(System.getProperty("user.dir"));
        this.loadIn(System.getProperty("user.home"));
        this.updateSettingsFromProperties();
        if (System.getProperty("useHTTPSProxy") != null && System.getProperty("useHTTPSProxy").equalsIgnoreCase("true")) {
            this.useHTTPSProxy = true;
        }
        this.javaNoProxyEntries = new Vector();
        if (System.getProperty("proxyPort") != null && System.getProperty("proxyHost") != null) {
            this.useProxy = this.useJavaProxy = true;
            this.useBrowserProxy = this.useJavaProxy;
            this.javaProxyPort = System.getProperty("proxyPort");
            this.javaProxyPortNum = Integer.parseInt(this.javaProxyPort);
            this.browserProxyHost = this.javaProxyHost = System.getProperty("proxyHost");
            this.browserProxyPort = this.javaProxyPortNum;
            if (System.getProperty("http.nonProxyHosts") != null) {
                this.useJavaNoProxy = true;
                this.javaNoProxy = System.getProperty("http.nonProxyHosts");
                StringTokenizer stringTokenizer = new StringTokenizer(this.javaNoProxy, "|");
                while (stringTokenizer.hasMoreTokens()) {
                    String string = stringTokenizer.nextToken() + "/";
                    this.javaNoProxyEntries.add(string);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void loadIn(String string) {
        block13: {
            FileInputStream fileInputStream = null;
            String string2 = System.getProperty("file.separator");
            fileInputStream = new FileInputStream(string + string2 + "jemboss.properties");
            this.jembossSettings.load(fileInputStream);
            Object var5_6 = null;
            if (fileInputStream == null) break block13;
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            fileInputStream = null;
            {
                break block13;
                catch (FileNotFoundException fileNotFoundException) {
                    fileInputStream = null;
                    if (this.debug) {
                        System.out.println("Can't find properties file in" + string + "." + " Using defaults.");
                    }
                    Object var5_7 = null;
                    if (fileInputStream == null) break block13;
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    fileInputStream = null;
                    break block13;
                }
                catch (IOException iOException) {
                    if (this.debug) {
                        System.out.println("Can't read properties file. Using defaults.");
                    }
                    Object var5_8 = null;
                    if (fileInputStream == null) break block13;
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                    fileInputStream = null;
                }
            }
            catch (Throwable throwable) {
                Object var5_9 = null;
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    fileInputStream = null;
                }
                throw throwable;
            }
        }
    }

    protected void updateSettingsFromProperties() {
        try {
            this.userHome = this.jembossSettings.getProperty(this.userHomeName);
            this.embURL = this.jembossSettings.getProperty(this.embossURL);
            this.plplot = this.jembossSettings.getProperty(this.plplotName);
            this.embossData = this.jembossSettings.getProperty(this.embossDataName);
            this.embossBin = this.jembossSettings.getProperty(this.embossBinName);
            this.embossPath = this.jembossSettings.getProperty(this.embossPathName);
            this.embossEnvironment = this.jembossSettings.getProperty(this.embossEnvironmentName);
            this.acdDirToParse = this.jembossSettings.getProperty(this.acdDirToParseName);
            String string = this.jembossSettings.getProperty(this.jembossServerName);
            jembossServer = new Boolean(string);
            cygwin = this.jembossSettings.getProperty(this.cygwinName);
            string = this.jembossSettings.getProperty(this.useHTTPSProxyName);
            this.useHTTPSProxy = new Boolean(string);
            string = this.jembossSettings.getProperty(this.useProxyName);
            this.useProxy = new Boolean(string);
            this.proxyHost = this.jembossSettings.getProperty(this.proxyHostName);
            string = this.jembossSettings.getProperty(this.proxyPortNumName);
            this.proxyPortNum = Integer.parseInt(string);
            string = this.jembossSettings.getProperty(this.useBrowserProxyName);
            this.useBrowserProxy = new Boolean(string);
            this.browserProxyHost = this.jembossSettings.getProperty(this.browserProxyHostName);
            string = this.jembossSettings.getProperty(this.browserProxyPortName);
            this.browserProxyPort = Integer.parseInt(string);
            string = this.jembossSettings.getProperty(this.useTFMName);
            this.useTFM = new Boolean(string);
            string = this.jembossSettings.getProperty(this.useProxyAuthName);
            this.useProxyAuth = new Boolean(string);
            this.proxyAuthUser = this.jembossSettings.getProperty(this.proxyAuthUserName);
            this.proxyAuthPasswd = this.jembossSettings.getProperty(this.proxyAuthPasswdName);
            string = this.jembossSettings.getProperty(this.proxyOverrideName);
            this.proxyOverride = new Boolean(string);
            string = this.jembossSettings.getProperty(this.useAuthName);
            this.useAuth = new Boolean(string);
            this.publicSoapURL = this.jembossSettings.getProperty(this.publicSoapURLName);
            this.privateSoapURL = this.jembossSettings.getProperty(this.privateSoapURLName);
            this.soapService = this.jembossSettings.getProperty(this.soapServiceName);
            this.privateSoapService = this.jembossSettings.getProperty(this.privateSoapServiceName);
            this.publicSoapService = this.jembossSettings.getProperty(this.publicSoapServiceName);
            string = this.jembossSettings.getProperty(this.debugName);
            this.debug = new Boolean(string);
            string = this.jembossSettings.getProperty(this.hasBatchModeName);
            this.hasBatchMode = new Boolean(string);
            string = this.jembossSettings.getProperty(this.hasInteractiveModeName);
            this.hasInteractiveMode = new Boolean(string);
            this.currentMode = this.jembossSettings.getProperty(this.currentModeName);
            this.serverPublicList = this.jembossSettings.getProperty(this.serverPublicListName);
            this.serverPrivateList = this.jembossSettings.getProperty(this.serverPrivateListName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void setupServerRedundancy() {
        String string;
        StringTokenizer stringTokenizer;
        if (!this.serverPublicList.equals("")) {
            if (this.debug) {
                System.out.println("JembossParams: Redundant public servers\n  " + this.serverPublicList);
            }
            this.publicServerFailOver = true;
            stringTokenizer = new StringTokenizer(this.serverPublicList, "|");
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
                this.publicServers.add(string);
                if (this.debug) {
                    System.out.println(" Entry " + string);
                }
                this.serverStatusHash.put(string, new Integer(0));
            }
        }
        if (!this.serverPrivateList.equals("")) {
            if (this.debug) {
                System.out.println("JembossParams: Redundant private servers\n  " + this.serverPrivateList);
            }
            this.privateServerFailOver = true;
            stringTokenizer = new StringTokenizer(this.serverPrivateList, "|");
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
                this.privateServers.add(string);
                if (this.debug) {
                    System.out.println(" Entry " + string);
                }
                this.serverStatusHash.put(string, new Integer(0));
            }
        }
    }

    public boolean getUseProxy() {
        return this.useProxy;
    }

    public boolean getUseHTTPSProxy() {
        return this.useHTTPSProxy;
    }

    public boolean getUseProxy(String string) {
        if (this.proxyOverride) {
            return this.useProxy;
        }
        if (!this.useJavaProxy) {
            return this.useProxy;
        }
        boolean bl = true;
        if (this.useJavaNoProxy) {
            int n = this.javaNoProxyEntries.size();
            for (int i = 0; i < n; ++i) {
                if (string.indexOf(this.javaNoProxyEntries.get(i).toString()) == -1) continue;
                bl = false;
            }
        }
        return bl;
    }

    public String getProxyHost() {
        if (this.proxyOverride) {
            return this.proxyHost;
        }
        if (!this.useJavaProxy) {
            return this.proxyHost;
        }
        return this.javaProxyHost;
    }

    public int getProxyPortNum() {
        if (this.proxyOverride) {
            return this.proxyPortNum;
        }
        if (!this.useJavaProxy) {
            return this.proxyPortNum;
        }
        return this.javaProxyPortNum;
    }

    public boolean isBrowserProxy() {
        return this.useBrowserProxy;
    }

    public String getBrowserProxyHost() {
        return this.browserProxyHost;
    }

    public int getBrowserProxyPort() {
        return this.browserProxyPort;
    }

    public boolean isUseTFM() {
        return this.useTFM;
    }

    public boolean getUseProxyAuth() {
        return this.useProxyAuth;
    }

    public String getProxyAuthUser() {
        return this.proxyAuthUser;
    }

    public String getProxyAuthPasswd() {
        return this.proxyAuthPasswd;
    }

    public String proxyDescription() {
        String string = "";
        if (this.proxyOverride) {
            if (this.useProxy) {
                String string2 = new Integer(this.proxyPortNum).toString();
                string = "Current Settings: Proxy Host: " + this.proxyHost + " Proxy Port: " + string2;
            } else {
                string = "No proxies, connecting direct.";
            }
        } else if (this.useJavaProxy) {
            string = "Settings Imported from Java: Proxy Host: " + this.javaProxyHost + " Proxy Port: " + this.javaProxyPort;
            if (this.useJavaNoProxy) {
                string = string + "\nNo Proxy On: " + this.javaNoProxy;
            }
        } else if (this.useProxy) {
            String string3 = new Integer(this.proxyPortNum).toString();
            string = "Current Settings: Proxy Host: " + this.proxyHost + " Proxy Port: " + string3;
        } else {
            string = "No proxies, connecting direct.";
        }
        return string;
    }

    public boolean getUseAuth() {
        return this.useAuth;
    }

    public String getPublicSoapURL() {
        return this.publicSoapURL;
    }

    public static boolean isJembossServer() {
        return jembossServer;
    }

    public static boolean isCygwin() {
        return cygwin != null && !cygwin.equals("");
    }

    public String getCygwinRoot() {
        return cygwin;
    }

    public String getPlplot() {
        return this.plplot;
    }

    public String getUserHome() {
        return this.userHome;
    }

    public void setUserHome(String string) {
        this.userHome = string;
    }

    public String getembURL() {
        return this.embURL;
    }

    public String getEmbossData() {
        return this.embossData;
    }

    public String getEmbossBin() {
        return this.embossBin;
    }

    public String getEmbossPath() {
        return this.embossPath;
    }

    public String getEmbossEnvironment() {
        this.embossEnvironment = this.embossEnvironment.trim();
        this.embossEnvironment = this.embossEnvironment.replace(':', ' ');
        this.embossEnvironment = this.embossEnvironment.replace(',', ' ');
        return this.embossEnvironment;
    }

    public String[] getEmbossEnvironmentArray(String[] stringArray) {
        this.embossEnvironment = this.embossEnvironment.trim();
        this.embossEnvironment = this.embossEnvironment.replace(':', ' ');
        this.embossEnvironment = this.embossEnvironment.replace(',', ' ');
        if (this.embossEnvironment.equals("")) {
            return stringArray;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.embossEnvironment, " ");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringTokenizer.nextToken();
            ++n;
        }
        int n2 = stringArray.length;
        String[] stringArray2 = new String[n + n2];
        stringTokenizer = new StringTokenizer(this.embossEnvironment, " ");
        for (int i = 0; i < n2; ++i) {
            stringArray2[i] = stringArray[i];
        }
        n = n2;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray2[n] = new String(stringTokenizer.nextToken());
            ++n;
        }
        return stringArray2;
    }

    public String getAcdDirToParse() {
        return this.acdDirToParse;
    }

    public void setPublicSoapURL(String string) {
        this.publicSoapURL = string;
    }

    public String getPrivateSoapURL() {
        return this.privateSoapURL;
    }

    public void setPrivateSoapURL(String string) {
        this.privateSoapURL = string;
    }

    public boolean getPublicServerFailover() {
        return this.publicServerFailOver;
    }

    public boolean getPrivateServerFailover() {
        return this.privateServerFailOver;
    }

    public Vector getPublicServers() {
        return this.publicServers;
    }

    public Vector getPrivateServers() {
        return this.privateServers;
    }

    public void setServerStatus(String string, int n) {
        this.serverStatusHash.put(string, new Integer(n));
    }

    public String getServiceUserName() {
        return this.serviceUserName;
    }

    public void setServiceUserName(String string) {
        this.serviceUserName = string;
    }

    public char[] getServicePasswd() {
        return this.servicePasswd;
    }

    public byte[] getServicePasswdByte() {
        return this.servicePasswdByte;
    }

    private static byte[] toByteArr(char[] cArray) {
        int n = cArray.length;
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)cArray[i];
        }
        return byArray;
    }

    public void setServicePasswd(char[] cArray) {
        int n = cArray.length;
        this.servicePasswd = new char[n];
        for (int i = 0; i < n; ++i) {
            this.servicePasswd[i] = cArray[i];
        }
        this.servicePasswdByte = JembossParams.toByteArr(cArray);
    }

    public String getSoapService() {
        return this.soapService;
    }

    public String getPrivateSoapService() {
        return this.privateSoapService;
    }

    public void setPrivateSoapService(String string) {
        this.privateSoapService = string;
    }

    public String getPublicSoapService() {
        return this.publicSoapService;
    }

    public void setPublicSoapService(String string) {
        this.publicSoapService = string;
    }

    public String serverDescription() {
        String string = "Current Settings:\nPublic Server: " + this.publicSoapURL + "\nPrivate Server: " + this.privateSoapURL + "\nPublic SOAP service: " + this.publicSoapService + "\nPrivate SOAP service: " + this.privateSoapService;
        return string;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public boolean getHasBatchMode() {
        return this.hasBatchMode;
    }

    public boolean getHasInteractiveMode() {
        return this.hasInteractiveMode;
    }

    public String getCurrentMode() {
        if (this.hasInteractiveMode) {
            if (this.hasBatchMode) {
                return this.currentMode;
            }
            return "interactive";
        }
        if (this.hasBatchMode) {
            return "batch";
        }
        return this.currentMode;
    }

    public void setCurrentMode(String string) {
        this.currentMode = string;
    }

    public Vector modeVector() {
        Vector<String> vector = new Vector<String>();
        if (this.hasInteractiveMode) {
            if (this.hasBatchMode) {
                if (this.currentMode.equals("interactive")) {
                    vector.add("interactive");
                    vector.add("batch");
                } else if (this.currentMode.equals("batch")) {
                    vector.add("batch");
                    vector.add("interactive");
                } else {
                    vector.add(this.currentMode);
                    vector.add("interactive");
                    vector.add("batch");
                }
            } else {
                vector.add("interactive");
            }
        } else if (this.hasBatchMode) {
            vector.add("batch");
        }
        return vector;
    }

    public void updateJembossProperty(String string, String string2) {
        if (this.jembossSettings.getProperty(string) != null) {
            this.jembossSettings.setProperty(string, string2);
        }
    }

    public void updateJembossPropString(String string) {
        int n = string.indexOf(61);
        if (n != -1) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            this.updateJembossProperty(string2, string3);
        }
    }

    public void updateJembossPropStrings(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.updateJembossPropString(stringArray[i]);
        }
        this.updateSettingsFromProperties();
        this.setupServerRedundancy();
    }

    public void updateJembossPropHash(Hashtable hashtable) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            String string2 = (String)hashtable.get(string);
            this.updateJembossProperty(string, string2);
        }
        this.updateSettingsFromProperties();
    }
}

