/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.editor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.emboss.jemboss.editor.ColourMenu;

public class ColourPanel
extends JPanel
implements ActionListener {
    protected Color col;
    private int xsize = 20;
    private int ysize = 20;
    private JPopupMenu popup;

    public ColourPanel(String string, Color color) {
        this.col = color;
        this.setPreferredSize(new Dimension(this.xsize, this.ysize));
        this.setMaximumSize(new Dimension(this.xsize, this.ysize));
        ColourMenu colourMenu = new ColourMenu(string);
        this.popup = new JPopupMenu();
        this.addMouseListener(new PopupListener());
        colourMenu.addActionListener(this);
        this.popup.add(colourMenu);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        ColourMenu colourMenu = (ColourMenu)actionEvent.getSource();
        this.col = colourMenu.getColor();
        this.repaint();
    }

    public Color getColour() {
        return this.col;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        graphics.setColor(this.col);
        graphics.fillRect(0, 0, this.xsize, this.ysize);
        graphics.setColor(Color.black);
        graphics.drawRect(0, 0, this.xsize, this.ysize);
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                ColourPanel.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

